/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.util;

import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import java.io.Serializable;

public class PagedFliper
implements Serializable {
    public static int DEFAULTPAGESIZE = 50;
    private static final String HIDDEN_PAGESIZE = "__hidden_pagesize_";
    private static final String HIDDEN_PAGENO = "__hidden_pageno_";
    private static final String HIDDEN_SORTCOLUMN = "__hidden_sortcolumn_";
    private int index = 1;
    private int pageNo = 1;
    private int recordCount;
    private String sortColumn = "";
    private int pageSize = DEFAULTPAGESIZE;

    public PagedFliper() {
    }

    public PagedFliper(int pageSize) {
        this.pageSize = pageSize;
    }

    public PagedFliper(int pageSize, int pageNo, String sortColumn) {
        this.pageSize = pageSize;
        this.pageNo = pageNo;
        if (sortColumn != null) {
            this.sortColumn = sortColumn.trim();
        }
    }

    public void reset() {
        this.pageNo = 1;
        this.sortColumn = "";
    }

    public final String limitsql(int rowcount) {
        if (!this.isValid()) {
            return " ";
        }
        return PagedFliper.addLimitToSql(rowcount, this.getPageSize(), this.getPageNo());
    }

    public String getHiddenPageSizeId() {
        return HIDDEN_PAGESIZE + (this.getIndex() < 2 ? "" : "" + this.getIndex());
    }

    public String getHiddenPageNoId() {
        return HIDDEN_PAGENO + (this.getIndex() < 2 ? "" : "" + this.getIndex());
    }

    public String getHiddenSortColumnId() {
        return HIDDEN_SORTCOLUMN + (this.getIndex() < 2 ? "" : "" + this.getIndex());
    }

    public String getFormathtml() {
        String pagesizeid = this.getHiddenPageSizeId();
        String pagenoid = this.getHiddenPageNoId();
        String sortcolumnid = this.getHiddenSortColumnId();
        StringBuilder sb = new StringBuilder(80);
        sb.append("<input type='hidden' id='").append(pagesizeid).append("' name='").append(pagesizeid).append("' value='").append(this.getPageSize()).append("' />");
        sb.append("<input type='hidden' id='").append(pagenoid).append("' name='").append(pagenoid).append("' value='").append(this.getPageNo()).append("' />");
        sb.append("<input type='hidden' id='").append(sortcolumnid).append("' name='").append(sortcolumnid).append("' value='").append(this.getSortColumn()).append("' />");
        return sb.toString();
    }

    public String toString() {
        return "PagedFliper[pageNo=" + this.pageNo + ", pageSize=" + this.pageSize + ", sortColumn=" + this.getSortColumn() + ", index=" + this.index + "]";
    }

    public int getIndex() {
        if (this.index < 1) {
            return 1;
        }
        return this.index;
    }

    public void setIndex(int index) {
        if (index > 0) {
            this.index = index;
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getSmoothPageNo() {
        int pageCount = this.getPageCount();
        if (this.getPageNo() > pageCount) {
            return 1;
        }
        return this.getPageNo();
    }

    public int getSmoothCurrentPageRecordCount() {
        if (this.getSmoothPageNo() < this.getPageCount()) {
            return this.getPageSize();
        }
        return this.recordCount - this.getPageSize() * (this.getPageCount() - 1);
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public String getSortColumn() {
        if ("null".equals(this.sortColumn)) {
            return "";
        }
        return this.sortColumn;
    }

    public void setSortColumnIfEmpty(String sortColumn) {
        if (this.isEmptySortColumn()) {
            this.setSortColumn(sortColumn);
        }
    }

    public void setSortColumn(String sortColumn) {
        if (sortColumn != null && !"null".equals(sortColumn.trim())) {
            this.sortColumn = StringTools.escapeSql(sortColumn.trim());
        }
    }

    public boolean isEmptySortColumn() {
        return this.getSortColumn() == null || this.getSortColumn().length() == 0;
    }

    public boolean isNotEmptySortColumn() {
        return this.getSortColumn() != null && this.getSortColumn().length() != 0;
    }

    private boolean isValid() {
        return this.getPageSize() > 0 && this.getPageNo() > 0;
    }

    private static int computeStartRowNo(int rowcount, int pagesize, int pageno) {
        if (rowcount < 0 || pagesize < 1 || pageno < 1) {
            throw new XLRuntimeException("\u7528\u4e8e\u8ba1\u7b97\u7ffb\u9875\u8d77\u59cb\u884c\u7684\u53c2\u6570\u4e0d\u6b63\u786e!");
        }
        if (rowcount == 0) {
            return 0;
        }
        int startrowno = (pageno - 1) * pagesize;
        if (startrowno >= rowcount) {
            startrowno = rowcount % pagesize == 0 ? rowcount - pagesize : rowcount / pagesize * pagesize;
        }
        return startrowno;
    }

    private static String addLimitToSql(int rowcount, int pagesize, int pageno) {
        int startrowno = PagedFliper.computeStartRowNo(rowcount, pagesize, pageno);
        return " limit " + startrowno + "," + pagesize;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public boolean reCountParameter() {
        int pc = this.getPageCount();
        if (this.pageNo > pc) {
            this.pageNo = pc;
            return true;
        }
        return false;
    }

    public int getCurrentPageRecordStartIndex() {
        if (this.getRecordCount() == 0) {
            return 0;
        }
        return (this.getSmoothPageNo() - 1) * this.pageSize + 1;
    }

    public int getCurrentPageRecordEndIndex() {
        int startIndex = this.getCurrentPageRecordStartIndex();
        if (startIndex == 0) {
            return 0;
        }
        return startIndex - 1 + this.getCurrentPageRecordCount();
    }

    public static void main(String[] args) {
        PagedFliper fliper = new PagedFliper(2, 1, "");
        fliper.setRecordCount(100);
        System.out.println(fliper.getCurrentPageRecordStartIndex() + ".." + fliper.getCurrentPageRecordEndIndex());
    }

    public int getPageCount() {
        if (this.recordCount == 0) {
            return 0;
        }
        return this.recordCount % this.pageSize == 0 ? this.recordCount / this.pageSize : this.recordCount / this.pageSize + 1;
    }

    public int getCurrentPageRecordCount() {
        if (this.getPageNo() < this.getPageCount()) {
            return this.getPageSize();
        }
        return this.recordCount - this.getPageSize() * (this.getPageCount() - 1);
    }

    public String getSetPageNoScript(String pageNo) {
        StringBuilder sb = new StringBuilder();
        sb.append("document.getElementById('").append(this.getHiddenPageNoId()).append("').value=").append(pageNo).append(";if(typeof(doPager)=='function')doPager();");
        return sb.toString();
    }

    public String getSetPageSizeStript(String pageSize) {
        StringBuilder sb = new StringBuilder();
        sb.append("document.getElementById('").append(this.getHiddenPageSizeId()).append("').value=").append(pageSize).append(";");
        sb.append("document.getElementById('").append(this.getHiddenPageNoId()).append("').value=1;");
        sb.append("if(typeof(doPager)=='function')doPager();");
        return sb.toString();
    }
}

