/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.util;

import com.xunlei.common.util.ExplorerParams;
import com.xunlei.common.util.XLRuntimeException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.UnderlineStyle;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelExplorer<T> {
    private ExplorerParams<T> ep;
    private static final int EXCEL_HEIGHT = 810;
    private int fontsize;
    private String[] tHeadNames;
    private String[] tDataFieldNames;
    private String[] rowStyles;
    private ArrayList<T> datalist;
    private Class clazz;
    private float[] widths;
    private Colour[] colors;
    private Alignment[] aligns;

    public ExcelExplorer(ExplorerParams param) {
        this.ep = param;
        this.initParam();
    }

    private void initParam() {
        if (this.ep.getClazz() == null || this.ep.getTitle() == null || this.ep.getHeaderNames() == null || this.ep.getDataFieldNames() == null || this.ep.getDatalist() == null) {
            throw new XLRuntimeException("\u5fc5\u987b\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.tHeadNames = this.ep.getHeaderNames().split(",");
        this.tDataFieldNames = this.ep.getDataFieldNames().split(",");
        if (this.ep.getDataFieldStyles() != null && !this.ep.getDataFieldStyles().equals("")) {
            this.rowStyles = this.ep.getDataFieldStyles().split(",");
        }
        this.datalist = this.ep.getDatalist();
        this.clazz = this.ep.getClazz();
        this.fontsize = this.ep.getFontSize();
        if (this.tHeadNames.length == 0 || this.tHeadNames.length != this.tDataFieldNames.length) {
            throw new XLRuntimeException("\u53c2\u6570\u8bbe\u7f6e\u6709\u8bef");
        }
        if (this.rowStyles != null && this.rowStyles.length != this.tHeadNames.length) {
            throw new XLRuntimeException("\u6837\u5f0f\u8bbe\u7f6e\u6709\u8bef,\u6837\u5f0f\u4e2a\u6570\u5fc5\u987b\u4e0e\u603b\u5217\u6570\u76f8\u7b49");
        }
        this.setTableStyle(this.tHeadNames.length, this.rowStyles);
    }

    private void setTableStyle(int col, String[] styles) {
        this.widths = new float[col];
        this.colors = new Colour[col];
        this.aligns = new Alignment[col];
        try {
            if (styles == null || styles.length == 0) {
                float width = (float)(1.0 / (double)col);
                for (int i = 0; i < col; ++i) {
                    this.widths[i] = width;
                    this.colors[i] = Colour.BLACK;
                    this.aligns[i] = Alignment.CENTRE;
                }
            } else {
                float[] totalwidth = new float[col];
                float total = 0.0f;
                int index = 0;
                for (String str : styles) {
                    String colorstr;
                    StringTokenizer token = new StringTokenizer(str, "|");
                    if (token.hasMoreTokens()) {
                        float itemwidth;
                        String data = token.nextToken();
                        String widthdata = data.substring(0, data.length() - 1);
                        totalwidth[index] = itemwidth = Float.parseFloat(widthdata);
                        total += itemwidth;
                        String hdata = data.substring(data.length() - 1);
                        this.aligns[index] = hdata.equalsIgnoreCase("R") ? Alignment.RIGHT : (hdata.equalsIgnoreCase("L") ? Alignment.LEFT : Alignment.CENTRE);
                    }
                    this.colors[index] = token.hasMoreTokens() ? ((colorstr = token.nextToken()).equalsIgnoreCase("red") ? Colour.RED : (colorstr.equalsIgnoreCase("blue") ? Colour.BLUE : (colorstr.equalsIgnoreCase("gray") ? Colour.GRAY_25 : (colorstr.equalsIgnoreCase("green") ? Colour.GREEN : Colour.BLACK)))) : Colour.BLACK;
                    ++index;
                }
                for (int i = 0; i < col; ++i) {
                    this.widths[i] = totalwidth[i] / total;
                }
            }
        }
        catch (Exception e) {
            throw new XLRuntimeException("\u6837\u5f0f\u8bbe\u7f6e\u6709\u8bef");
        }
    }

    public void writeToExcel(OutputStream out) {
        try {
            String sheetName = this.ep.getTitle();
            WritableWorkbook wwb = Workbook.createWorkbook((OutputStream)out);
            WritableSheet ws = wwb.createSheet(sheetName, 0);
            ws.setRowView(0, 810, false);
            WritableFont wfc1 = new WritableFont(WritableFont.ARIAL, this.fontsize + 3, WritableFont.BOLD, false, UnderlineStyle.getStyle((int)0));
            WritableCellFormat wcfFC1 = new WritableCellFormat(wfc1);
            wcfFC1.setBorder(Border.NONE, BorderLineStyle.THIN);
            wcfFC1.setAlignment(Alignment.CENTRE);
            wcfFC1.setWrap(false);
            int titlepos = this.tHeadNames.length / 2;
            Label label2 = new Label(titlepos, 0, sheetName, (CellFormat)wcfFC1);
            ws.addCell((WritableCell)label2);
            WritableFont wfc2 = new WritableFont(WritableFont.ARIAL, this.fontsize, WritableFont.BOLD, false, UnderlineStyle.getStyle((int)0));
            WritableCellFormat wcfFC2 = new WritableCellFormat(wfc2);
            wcfFC2.setBorder(Border.ALL, BorderLineStyle.THIN);
            wcfFC2.setAlignment(Alignment.CENTRE);
            wcfFC2.setWrap(false);
            Label[] titleLabels = new Label[this.tHeadNames.length];
            for (int n = 0; n < titleLabels.length; ++n) {
                ws.setColumnView(n, 20);
                titleLabels[n] = new Label(n, 1, this.tHeadNames[n], (CellFormat)wcfFC2);
                ws.addCell((WritableCell)titleLabels[n]);
            }
            Label[] labels = new Label[this.tHeadNames.length];
            for (int row = 0; row < this.datalist.size(); ++row) {
                T t = this.datalist.get(row);
                for (int column = 0; column < labels.length; ++column) {
                    WritableFont wfc3 = new WritableFont(WritableFont.ARIAL, this.fontsize, WritableFont.NO_BOLD, false, UnderlineStyle.getStyle((int)0));
                    wfc3.setColour(this.colors[column]);
                    WritableCellFormat wcfFC3 = new WritableCellFormat(wfc3);
                    wcfFC3.setBorder(Border.ALL, BorderLineStyle.THIN);
                    wcfFC3.setAlignment(this.aligns[column]);
                    wcfFC3.setWrap(false);
                    Method method = this.clazz.getDeclaredMethod("get" + ExcelExplorer.capitalize(this.tDataFieldNames[column]), new Class[0]);
                    Object value = method.invoke(t, new Object[0]);
                    String valuestr = value.toString();
                    Class<?> rtntype = method.getReturnType();
                    String type = rtntype.getSimpleName();
                    labels[column] = new Label(column, row + 2, valuestr, (CellFormat)wcfFC3);
                    ws.addCell((WritableCell)labels[column]);
                }
            }
            wwb.write();
            wwb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeToFile(String filePath) {
        try {
            FileOutputStream fo = new FileOutputStream(filePath);
            this.writeToExcel(fo);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

