/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DatetimeUtil {
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final DateFormat daydf = new SimpleDateFormat("yyyy-MM-dd");

    private DatetimeUtil() {
    }

    public static Date formatDayTime(String day) {
        try {
            return daydf.parse(day);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            return new Date();
        }
    }

    public static Date formatMonthTime(String yearmonth) {
        try {
            return daydf.parse(yearmonth + "-01");
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            return new Date();
        }
    }

    public static long parseDayByYYYYMMDD(String str) {
        try {
            return daydf.parse(str).getTime();
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static int parseTimeByYYYYMMDDHHMMSS(String str) {
        if (str == null || str.length() != 19) {
            return 0;
        }
        try {
            return (int)(df.parse(str).getTime() / 1000L);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static String foreDay(String day) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(DatetimeUtil.parseDayByYYYYMMDD(day));
        cal.add(5, -1);
        return daydf.format(cal.getTime());
    }

    public static String parseDay(int time) {
        return daydf.format(new Date((long)time * 1000L));
    }

    public static String displayTime(long millseconds) {
        if (millseconds < 1000L) {
            return millseconds + " \u6beb\u79d2";
        }
        int seconds = (int)(millseconds / 1000L);
        if (seconds < 60) {
            return seconds + " \u79d2";
        }
        if (seconds < 3600) {
            return seconds / 60 + "\u5206" + seconds % 60 + "\u79d2";
        }
        int m = seconds - seconds / 3600 * 3600;
        if (seconds < 86400) {
            return seconds / 3600 + "\u5c0f\u65f6" + m / 60 + "\u5206" + m % 60 + "\u79d2";
        }
        return millseconds + " \u6beb\u79d2";
    }

    public static String formatDay(Date d) {
        return daydf.format(d);
    }

    public static String formatDay(Calendar d) {
        return daydf.format(d.getTime());
    }

    public static String formatyyyyMMddHHmmss(long time) {
        return df.format(new Date(time));
    }

    public static String formatyyyyMMddHHmmss(Date time) {
        if (time == null) {
            return "";
        }
        return df.format(time);
    }

    public static String today() {
        return daydf.format(new Date());
    }

    public static String otherdateofnow() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return sdf.format(new Date());
    }

    public static String yesterday() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        return daydf.format(cal.getTime());
    }

    public static String tomorrow() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        return daydf.format(cal.getTime());
    }

    public static String currmonth1day() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        return daydf.format(cal.getTime());
    }

    public static String lastdayofmonth() {
        Calendar calendar = Calendar.getInstance();
        Calendar cpcalendar = (Calendar)calendar.clone();
        cpcalendar.set(5, 1);
        cpcalendar.add(2, 1);
        cpcalendar.add(5, -1);
        String date = daydf.format(new Date(cpcalendar.getTimeInMillis()));
        return date;
    }

    public static String firstdayofyear() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String year = sdf.format(new Date());
        return year + "-01-01";
    }

    public static String lastdayofyear() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String year = sdf.format(new Date());
        return year + "-12-31";
    }

    public static String addTime(String time1, String addpart, int num) {
        try {
            String now = df.format(new Date());
            String string = time1 = time1 == null ? now : time1;
            if (time1.length() < 19) {
                time1 = time1 + " 00:00:00";
            }
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(df.parse(time1));
            if (addpart.equalsIgnoreCase("Y")) {
                cal.add(1, num);
            } else if (addpart.equalsIgnoreCase("M")) {
                cal.add(2, num);
            } else if (addpart.equalsIgnoreCase("D")) {
                cal.add(5, num);
            } else if (addpart.equalsIgnoreCase("H")) {
                cal.add(10, num);
            } else if (addpart.equalsIgnoreCase("F")) {
                cal.add(12, num);
            } else if (addpart.equalsIgnoreCase("S")) {
                cal.add(13, num);
            }
            return df.format(cal.getTime());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String addDate(String date1, String addpart, int num) {
        return DatetimeUtil.addTime(date1, addpart, num).substring(0, 10);
    }

    public static String now() {
        return df.format(new Date());
    }

    public static String timeofnow() {
        Calendar curcal = Calendar.getInstance();
        return df.format(curcal.getTime());
    }

    public static String othertimeofnow() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Calendar curcal = Calendar.getInstance();
        return sdf.format(curcal.getTime());
    }

    public static String dateofSepcial(int step) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, step);
        return daydf.format(cal.getTime());
    }
}

