/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.util;

import com.xunlei.common.vo.LibConfig;
import com.xunlei.common.web.model.WebContext;
import java.io.InputStream;
import java.util.Properties;

public class ApplicationConfigUtil {
    public static final String WEBROOT = WebContext.WEBROOT;
    protected static final Properties prop = new Properties();

    public static boolean isClearupTempdir() {
        return "true".equalsIgnoreCase(LibConfig.getValue("ClearupTempdir", "true"));
    }

    public static String[] getExcludePages() {
        String pages = LibConfig.getValue("ExcludePages", "index.jsp,login.jsf").toLowerCase();
        return pages.split(",");
    }

    public static String[] getExcludeCatalogs() {
        String catalogs = LibConfig.getValue("ExcludePaths", "").toLowerCase();
        return catalogs.split(",");
    }

    public static String[] getFilterpaths() {
        String catalogs = LibConfig.getValue("FilterPaths", "").toLowerCase();
        return catalogs.split(",");
    }

    public static boolean isCookies() {
        return "true".equalsIgnoreCase(LibConfig.getValue("IsCookies", "false"));
    }

    public static String getCssPath() {
        return LibConfig.getValue("CssPath", "/css/blue/");
    }

    public static int getMailupdateInterval() {
        String v = LibConfig.getValue("MailUpdateInterval");
        return Integer.valueOf(v) * 1000;
    }

    public static String getFlatclassno() {
        return LibConfig.getValue("FlatClassNo");
    }

    public static String getFlattable() {
        return LibConfig.getValue("FlatTable");
    }

    public static String getFlatid() {
        return LibConfig.getValue("FlatId");
    }

    public static String getFlatname() {
        return LibConfig.getValue("FlatName");
    }

    public static String getFlatindex() {
        return LibConfig.getValue("FlatIndex");
    }

    public static String getRecnofield() {
        return LibConfig.getValue("RecNoField");
    }

    public static String getRootFilePath() {
        return LibConfig.getValue("RootFilesPath");
    }

    public static String getFilesDomain() {
        return LibConfig.getValue("FilesDomain");
    }

    public static String getValue(String key, String defaultValue) {
        return prop.getProperty(key, defaultValue);
    }

    public static boolean getShownavi() {
        return Boolean.parseBoolean(LibConfig.getValue("ShowNavi", "true"));
    }

    public static int getFunctionlogsStoreDay() {
        return Integer.parseInt(LibConfig.getValue("LogStoreDays"));
    }

    public static String getFunctionlogsDelDate() {
        return LibConfig.getValue("LogDelDate");
    }

    static {
        try {
            InputStream in = ApplicationConfigUtil.class.getResourceAsStream("/META-INF/commonConfig.properties");
            prop.load(in);
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

