/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.dao;

import com.xunlei.common.dao.IPlusOperationDao;
import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.PlusOperation;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class PlusOperationDaoImpl
extends JdbcBaseDao
implements IPlusOperationDao {
    @Override
    public List<PlusOperation> getAllPlusOperation() {
        final ArrayList<PlusOperation> datas = new ArrayList<PlusOperation>();
        String sql = "select * from plusoperation order by DisplayOrder asc";
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                PlusOperation data = new PlusOperation();
                data.setSeqid(rs.getLong("seqid"));
                data.setOperateno(rs.getString("OperateNo"));
                data.setOperatename(rs.getString("OperateName"));
                data.setDisplayorder(rs.getInt("DisplayOrder"));
                data.setRemark(rs.getString("Remark"));
                data.setInuse(rs.getShort("inuse"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    @Deprecated
    public List<PlusOperation> getOperationView(PlusOperation opr, int rowcount, int pagesize, int pageno, String sortColumn) {
        final ArrayList<PlusOperation> datas = new ArrayList<PlusOperation>();
        String sql = "select op.* from plusoperation op ";
        String condition = "";
        if (opr != null) {
            if (this.isNotEmpty(opr.getOperatename())) {
                condition = condition + " op.operatename like '%" + opr.getOperatename() + "%' and ";
            }
            if (this.isNotEmpty(opr.getOperateno())) {
                condition = condition + " op.operateno ='" + opr.getOperateno() + "' and ";
            }
            if (this.isNotEmpty(condition)) {
                sql = sql + " where " + condition.substring(0, condition.length() - 4);
            }
        }
        sql = sql + "order by " + (this.isEmpty(sortColumn) ? "DisplayOrder asc, OperateNo asc " : "DisplayOrder asc, " + sortColumn);
        sql = this.addLimitToSql(sql, rowcount, pagesize, pageno);
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                PlusOperation data = new PlusOperation();
                data.setSeqid(rs.getLong("seqid"));
                data.setOperateno(rs.getString("OperateNo"));
                data.setOperatename(rs.getString("OperateName"));
                data.setDisplayorder(rs.getInt("DisplayOrder"));
                data.setRemark(rs.getString("Remark"));
                data.setInuse(rs.getShort("inuse"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    @Deprecated
    public int getOperationViewCount(PlusOperation opr) {
        String sql = "select count(*) from plusoperation op";
        String condition = "";
        if (opr != null) {
            if (this.isNotEmpty(opr.getOperatename())) {
                condition = condition + " op.operatename like '%" + opr.getOperatename() + "%' and ";
            }
            if (this.isNotEmpty(opr.getOperateno())) {
                condition = condition + " op.operateno ='" + opr.getOperateno() + "' and ";
            }
            if (this.isNotEmpty(condition)) {
                sql = sql + " where " + condition.substring(0, condition.length() - 4);
            }
        }
        return super.getSingleInt(sql);
    }

    @Override
    public void insertOperation(PlusOperation data) {
        this.saveObject(data);
    }

    @Override
    public void updateOperation(PlusOperation data) {
        this.updateObject(data);
    }

    @Override
    public void removeOperation(PlusOperation data) {
        this.deleteObject(data);
    }

    @Override
    public void removeOperation(long seqid) {
        this.deleteObject("plusoperation", seqid);
    }

    @Override
    public List<PlusOperation> getPlusOperation(PlusOperation plusOperation) {
        return this.findObjects(plusOperation, null, null);
    }

    @Override
    public Sheet<PlusOperation> queryPlusOperations(PlusOperation plopr, PagedFliper fliper) {
        String countsql;
        int rowcount;
        String where = " where 1=1 ";
        if (plopr != null) {
            if (this.isNotEmpty(plopr.getOperateno())) {
                where = where + " and operateno like '%" + plopr.getOperateno() + "%' ";
            }
            if (this.isNotEmpty(plopr.getOperatename())) {
                where = where + " and operatename like '%" + plopr.getOperatename() + "%' ";
            }
        }
        if ((rowcount = super.getSingleInt(countsql = " select count(seqid) from plusoperation " + where)) == 0) {
            return Sheet.EMPTY;
        }
        String sql = " select * from plusoperation " + where;
        if (fliper != null) {
            if (fliper.isNotEmptySortColumn()) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet<PlusOperation>(rowcount, this.query(PlusOperation.class, sql, new String[0]));
    }

    @Override
    public List<PlusOperation> getPlusOperationByName(String operatename) {
        PlusOperation po = new PlusOperation();
        po.setOperatename(operatename);
        return this.getPlusOperation(po);
    }

    @Override
    public List<PlusOperation> getPlusOperationByNo(String operateno) {
        PlusOperation po = new PlusOperation();
        po.setOperateno(operateno);
        return this.getPlusOperation(po);
    }

    @Override
    public PlusOperation getOperatorById(long seqid) {
        PlusOperation po = new PlusOperation();
        po.setSeqid(seqid);
        return this.findObject(po);
    }
}

