/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.dao;

import com.xunlei.common.dao.IMenusDao;
import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.Menus;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class MenusDaoImpl
extends JdbcBaseDao
implements IMenusDao {
    @Override
    public List<Menus> getAllMenus(Short inuse) {
        final ArrayList<Menus> datas = new ArrayList<Menus>();
        String sql = "select m.seqid,m.menuno,m.menuname,m.pmenuno,m.menuid,m.menuurl,m.menuhint,m.menutarget,m.funcno,f.funcname,m.displayorder,m.inuse from menus m left join functions f on m.funcno = f.funcno ";
        if (inuse != null) {
            sql = sql + "where m.inuse = " + inuse;
        }
        sql = sql + " order by CONCAT('',m.displayorder),m.menuno";
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Menus data = new Menus();
                data.setSeqid(rs.getLong("seqid"));
                data.setMenuno(rs.getString("menuno"));
                data.setMenuname(rs.getString("menuname"));
                data.setPmenuno(rs.getString("pmenuno"));
                data.setMenuid(rs.getString("menuid"));
                data.setMenuurl(rs.getString("menuurl"));
                data.setMenuhint(rs.getString("menuhint"));
                data.setMenutarget(rs.getString("menutarget"));
                data.setFuncno(rs.getString("funcno"));
                data.setFuncname(rs.getString("funcname"));
                data.setDisplayorder(rs.getInt("displayorder"));
                data.setInuse(rs.getShort("inuse"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    public List<Menus> getRunMenusByUserLogo(String userlogo) {
        final ArrayList<Menus> datas = new ArrayList<Menus>();
        String sql = "select m.seqid,m.menuno,m.menuname,m.pmenuno,m.menuid,m.menuurl,m.menuhint,  m.menutarget, m.funcno, f.funcname, m.displayorder,m .inuse  from menus m, functions f, rolerights rr   where rr.RoleNo in (select RoleNo from usertorole where UserLogNo='" + userlogo + "') " + " and rr.FUNCNO =f.funcno and rr.ENABLERUN =1 and  m.funcno = f.funcno and m.inuse =1 " + " order by CONCAT('',m.displayorder),m.menuno";
        logger.debug(sql);
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Menus data = new Menus();
                data.setSeqid(rs.getLong("seqid"));
                data.setMenuno(rs.getString("menuno"));
                data.setMenuname(rs.getString("menuname"));
                data.setPmenuno(rs.getString("pmenuno"));
                data.setMenuid(rs.getString("menuid"));
                data.setMenuurl(rs.getString("menuurl"));
                data.setMenuhint(rs.getString("menuhint"));
                data.setMenutarget(rs.getString("menutarget"));
                data.setFuncno(rs.getString("funcno"));
                data.setFuncname(rs.getString("funcname"));
                data.setDisplayorder(rs.getInt("displayorder"));
                data.setInuse(rs.getShort("inuse"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    public List<Menus> getAllPMenus() {
        String sql = "select *  from menus m left join functions f on m.funcno = f.funcno where m.inuse = 1 and m.adminvisible=1 and PMenuNo='0' ";
        sql = sql + " order by CONCAT('',m.displayorder),m.menuno";
        return this.query(Menus.class, sql, new String[0]);
    }

    @Override
    public List<String> getRunPMenusByUserLogo(String userlogo) {
        final ArrayList<String> datas = new ArrayList<String>();
        String sql = "select distinct m.pmenuno  from menus m, functions f, rolerights rr   where rr.RoleNo in (select RoleNo from usertorole where UserLogNo='" + userlogo + "') " + " and rr.FUNCNO =f.funcno and rr.ENABLERUN =1 and  m.funcno = f.funcno and m.inuse =1 " + " order by CONCAT('',m.displayorder),m.menuno";
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                datas.add(rs.getString("pmenuno"));
            }
        });
        return datas;
    }

    @Override
    public List<Menus> getAllMenusByPMenuno(String pMenuno) {
        String sql = "select m.seqid as seqid,m.menuno as menuno,m.menuname as menuname,m.pmenuno as pmenuno,m.menuid as menuid,m.menuurl as menuurl,m.menuhint as menuhint,m.menutarget as menutarget,m.funcno as funcno,f.funcname as funcname,m.displayorder as displayorder,m.inuse as inuse,m.adminvisible as adminvisible from menus m left join functions f on m.funcno = f.funcno ";
        sql = sql + "where m.inuse = 1 and m.adminvisible=1 and m.pmenuno like '" + pMenuno;
        sql = sql + "%' order by CONCAT('',m.displayorder),m.menuno";
        return this.query(Menus.class, sql, "funcname");
    }

    @Override
    public List<Menus> getRunMenusByPMenuno(String userlogo, String pMenuno) {
        final ArrayList<Menus> datas = new ArrayList<Menus>();
        String sql = "select distinct m.seqid,m.menuno,m.menuname,m.pmenuno,m.menuid,m.menuurl,m.menuhint,  m.menutarget, m.funcno, f.funcname, m.displayorder,m .inuse  from menus m, functions f, rolerights rr   where rr.RoleNo in (select RoleNo from usertorole where UserLogNo='" + userlogo + "') " + " and rr.FUNCNO =f.funcno and rr.ENABLERUN =1 and  m.funcno = f.funcno and m.inuse =1 and m.pmenuno like '" + pMenuno + "%' order by CONCAT('',m.displayorder),m.menuno";
        logger.debug(sql);
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Menus data = new Menus();
                data.setSeqid(rs.getLong("seqid"));
                data.setMenuno(rs.getString("menuno"));
                data.setMenuname(rs.getString("menuname"));
                data.setPmenuno(rs.getString("pmenuno"));
                data.setMenuid(rs.getString("menuid"));
                data.setMenuurl(rs.getString("menuurl"));
                data.setMenuhint(rs.getString("menuhint"));
                data.setMenutarget(rs.getString("menutarget"));
                data.setFuncno(rs.getString("funcno"));
                data.setFuncname(rs.getString("funcname"));
                data.setDisplayorder(rs.getInt("displayorder"));
                data.setInuse(rs.getShort("inuse"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    public List<Menus> getRunMenusByUserModule(String userlogo, String moduleno) {
        final ArrayList<Menus> datas = new ArrayList<Menus>();
        String sql = "select m.seqid,m.menuno,m.menuname,m.pmenuno,m.menuid,m.menuurl,m.menuhint,  m.menutarget, m.funcno, f.funcname, m.displayorder,m .inuse  from menus m, functions f, rolerights rr   where rr.RoleNo in (select RoleNo from usertorole where UserLogNo='" + userlogo + "') " + " and rr.FUNCNO =f.funcno and rr.ENABLERUN =1 and  m.funcno = f.funcno and m.inuse =1 and f.moduleNo='" + moduleno + "' " + " order by CONCAT('',m.displayorder),m.menuno";
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Menus data = new Menus();
                data.setSeqid(rs.getLong("seqid"));
                data.setMenuno(rs.getString("menuno"));
                data.setMenuname(rs.getString("menuname"));
                data.setPmenuno(rs.getString("pmenuno"));
                data.setMenuid(rs.getString("menuid"));
                data.setMenuurl(rs.getString("menuurl"));
                data.setMenuhint(rs.getString("menuhint"));
                data.setMenutarget(rs.getString("menutarget"));
                data.setFuncno(rs.getString("funcno"));
                data.setFuncname(rs.getString("funcname"));
                data.setDisplayorder(rs.getInt("displayorder"));
                data.setInuse(rs.getShort("inuse"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    public List<Menus> getMenusByModule(String moduleno) {
        final ArrayList<Menus> datas = new ArrayList<Menus>();
        String sql = "select m.seqid,m.menuno,m.menuname,m.pmenuno,m.menuid,m.menuurl,m.menuhint,  m.menutarget, m.funcno, f.funcname, m.displayorder,m .inuse  from menus m, functions f  where m.funcno = f.funcno and m.inuse =1 and f.moduleNo='" + moduleno + "' " + " order by CONCAT('',m.displayorder),m.menuno";
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Menus data = new Menus();
                data.setSeqid(rs.getLong("seqid"));
                data.setMenuno(rs.getString("menuno"));
                data.setMenuname(rs.getString("menuname"));
                data.setPmenuno(rs.getString("pmenuno"));
                data.setMenuid(rs.getString("menuid"));
                data.setMenuurl(rs.getString("menuurl"));
                data.setMenuhint(rs.getString("menuhint"));
                data.setMenutarget(rs.getString("menutarget"));
                data.setFuncno(rs.getString("funcno"));
                data.setFuncname(rs.getString("funcname"));
                data.setDisplayorder(rs.getInt("displayorder"));
                data.setInuse(rs.getShort("inuse"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    public void insertMenus(Menus data) {
        this.saveObject(data);
    }

    @Override
    public void updateMenus(Menus data) {
        this.updateObject(data);
    }

    @Override
    public void removeMenus(Menus data) {
        this.deleteObject(data);
    }

    @Override
    public void removeMenus(long seqid) {
        this.deleteObject("menus", seqid);
    }

    @Override
    public void removeMenus(long[] seqids) {
        this.deleteObject("menus", seqids);
    }

    @Override
    public int countMenus(Menus menu) {
        StringBuilder sql = new StringBuilder("select count(*) from menus ");
        StringBuilder where = new StringBuilder(" where 1=1 ");
        int rowcount = -1;
        if (menu != null) {
            if (this.isNotEmpty(menu.getMenuno())) {
                where.append(" and menuno='").append(menu.getMenuno()).append("'");
            }
            if (menu.getSeqid() > 0L) {
                where.append(" and seqid=").append(menu.getSeqid());
            }
            if (menu.getDisplayorder() > 0L) {
                where.append(" and displayorder=").append(menu.getDisplayorder());
            }
            rowcount = this.getSingleInt(sql.append((CharSequence)where).toString());
        }
        return rowcount;
    }

    @Override
    public List<String> getAllMenuNos() {
        final ArrayList<String> datas = new ArrayList<String>();
        String sql = "select distinct m.menuno from menus m where m.inuse = 1 order by m.menuno ";
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                datas.add(rs.getString("menuno"));
            }
        });
        return datas;
    }

    @Override
    public List<String> getAllParentMenuString() {
        final ArrayList<String> datas = new ArrayList<String>();
        String sql = "select distinct m.menuno,m.menuname from menus m where  menuurl='' order by m.menuno ";
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                datas.add(rs.getString("menuno") + "|" + (MenusDaoImpl.this.isEmpty(rs.getString("menuname")) ? " " : rs.getString("menuname")));
            }
        });
        return datas;
    }

    @Override
    public Sheet<Menus> queryMenus(Menus menu, PagedFliper fliper) {
        String countsql;
        int rowcount;
        String where = "";
        if (menu != null && this.isNotEmpty(menu.getMenuno())) {
            where = "where menuno like '" + menu.getMenuno() + "%' ";
        }
        if ((rowcount = super.getSingleInt(countsql = " select count(*) from menus " + where)) == 0) {
            return Sheet.EMPTY;
        }
        String sql = "select m.*,f.funcname from menus m left join functions f on m.funcno = f.funcno " + where;
        if (fliper != null) {
            sql = fliper.isNotEmptySortColumn() ? sql + " order by " + fliper.getSortColumn() : sql + "order by  CONCAT('',m.displayorder), m.menuno ";
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet<Menus>(rowcount, this.query(Menus.class, sql, "funcname"));
    }

    @Override
    public String getMaxSubMenuNo(final String pMenuNo) {
        final ArrayList datas = new ArrayList(1);
        String sql = "select ifnull(max(m.menuno),null) from menus m where  m.menuno != '99' and m.PMenuNo ='" + pMenuNo + "' ";
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String s = rs.getString(1);
                if (s == null) {
                    s = "0".equals(pMenuNo) ? "01" : pMenuNo + "01";
                } else {
                    String p = pMenuNo;
                    if ("0".equals(p)) {
                        p = "0";
                    }
                    try {
                        s = p + MenusDaoImpl.fomartLong(Long.parseLong(s.substring(p.length())) + 1L);
                    }
                    catch (NumberFormatException ex) {
                        ex.printStackTrace();
                    }
                }
                datas.add(s);
            }
        });
        return (String)datas.get(0);
    }

    private static String fomartLong(long i) {
        if (i >= 99L) {
            throw new XLRuntimeException("\u7236\u83dc\u5355\u7f16\u53f7\u7684\u6700\u5927\u503c\u5df2\u523099\uff01");
        }
        String s = "00" + i;
        return s.substring(s.length() - 2);
    }

    @Override
    public boolean exchangeMenuOrder(String menuno, String pmenuno, String displayno, String way) {
        int len = displayno.length();
        if ("1000".equals(displayno)) {
            throw new XLRuntimeException("\u663e\u793a\u987a\u5e8f\u7684\u503c\u9519\u8bef, \u8bf7\u6267\u884cSQL\u811a\u672c update menus set DisplayOrder = CONCAT('1',MenuNo) \u540e\u91cd\u8bd5.");
        }
        String nextsql = "select CONCAT('',DisplayOrder) from menus where LENGTH(CONCAT('',DisplayOrder)) = " + len + " and PMenuNo='" + pmenuno + "' and DisplayOrder " + ("1".equals(way) ? " < " : " > ") + displayno + " order by CONCAT('',DisplayOrder) " + ("1".equals(way) ? " desc " : " asc ") + " limit 1";
        final ArrayList datas = new ArrayList(1);
        this.getJdbcTemplate().query(nextsql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                datas.add(rs.getString(1));
            }
        });
        if (datas.size() == 0) {
            return false;
        }
        String fuzhi2 = MenusDaoImpl.copy2(len);
        String nextno = (String)datas.get(0);
        String[] sqls = new String[]{"update menus set  DisplayOrder = CONCAT('" + fuzhi2 + "',substring(CONCAT('',DisplayOrder)," + (len + 1) + ")) where DisplayOrder like '" + nextno + "%' ", "update menus set  DisplayOrder = CONCAT('" + nextno + "',substring(CONCAT('',DisplayOrder)," + (len + 1) + ")) where DisplayOrder like '" + displayno + "%' ", "update menus set  DisplayOrder = CONCAT('" + displayno + "',substring(CONCAT('',DisplayOrder)," + (len + 1) + ")) where DisplayOrder like '" + fuzhi2 + "%' "};
        this.getJdbcTemplate().batchUpdate(sqls);
        return true;
    }

    private static String copy2(int len) {
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append('2');
        }
        return sb.toString();
    }

    @Override
    public Integer getMaxSubDisplayOrder(final String pMenuNo) {
        final ArrayList datas = new ArrayList(1);
        String sql = "select ifnull(max(m.displayorder),null) from menus m where m.inuse = 1 and m.menuno != '99' and m.PMenuNo ='" + pMenuNo + "' ";
        logger.debug("sql:" + sql);
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String s = rs.getString(1);
                if (s == null) {
                    Menus m = MenusDaoImpl.this.getMenusByMenuNo(pMenuNo);
                    s = String.valueOf(m.getDisplayorder()) + "01";
                } else {
                    String p = pMenuNo;
                    p = "1" + p;
                    try {
                        s = s.substring(0, p.length()) + MenusDaoImpl.fomartLong(Long.parseLong(s.substring(p.length())) + 1L);
                    }
                    catch (NumberFormatException ex) {
                        ex.printStackTrace();
                    }
                }
                datas.add(s);
            }
        });
        return Integer.valueOf((String)datas.get(0));
    }

    @Override
    public Menus getMenusByMenuNo(String menuNo) {
        Menus m = new Menus();
        m.setMenuno(menuNo);
        return this.findObjectByCondition(m);
    }

    @Override
    public Menus getAMenus(Menus m) {
        return this.findObjectByCondition(m);
    }

    @Override
    public List<Menus> getFrontFatherAccountMenus(String account) {
        String sql = "select m.seqid,m.menuno,m.menuname,m.pmenuno,m.menuid,m.menuurl,m.menuhint,  m.menutarget, m.funcno, m.displayorder,m .inuse,m.adminvisible  from menus m, functions f, rolerights rr   where rr.RoleNo in (select RoleNo from usertorole where UserLogNo='" + account + "')  and rr.FUNCNO =f.funcno and rr.ENABLERUN =1 and  m.funcno = f.funcno and m.inuse =1 and m.adminvisible=0  order by CONCAT('',m.displayorder),m.menuno";
        return this.query(Menus.class, sql, new String[0]);
    }

    @Override
    public List<Menus> getFrontSubAccountMenus(String subaccount) {
        String sql = "select m.seqid,m.menuno,m.menuname,m.pmenuno,m.menuid,m.menuurl,m.menuhint,  m.menutarget, m.funcno, m.displayorder,m .inuse,m.adminvisible  from menus m, usertofunction uf   where m.funcno = uf.funcno and uf.userlogno='" + subaccount + "' and m.inuse =1 and m.adminvisible=0  order by CONCAT('',m.displayorder),m.menuno";
        return this.query(Menus.class, sql, new String[0]);
    }
}

