/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.dao;

import com.xunlei.common.dao.ILibConfigDao;
import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.LibConfig;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class LibConfigDaoImpl
extends JdbcBaseDao
implements ILibConfigDao {
    @Override
    public List<LibConfig> getAllLibConfig() {
        return this.findObjects(new LibConfig(), null, null);
    }

    @Override
    public void insertLibConfig(LibConfig data) {
        this.saveObject(data);
    }

    @Override
    public void updateLibConfig(LibConfig data) {
        this.updateObject(data);
    }

    @Override
    public void removeLibConfig(LibConfig data) {
        this.deleteObject(data);
    }

    @Override
    public void removeLibConfig(long seqid) {
        this.deleteObject("libconfig", seqid);
    }

    @Override
    @Deprecated
    public int getLibConfigViewCount() {
        String sql = "select count(*) from libconfig ";
        return super.getSingleInt(sql);
    }

    @Override
    @Deprecated
    public int getLibConfigViewCount(LibConfig config) {
        String sql = "select count(*) from libconfig ";
        return super.getSingleInt(sql);
    }

    @Override
    @Deprecated
    public List<LibConfig> getLibConfigView(LibConfig config, String sortClomun, int rowcount, int pagesize, int pageno) {
        final ArrayList<LibConfig> datas = new ArrayList<LibConfig>();
        String sql = "select seqid,configno,configname,configvalue,remark from libconfig ";
        if (this.isNotEmpty(sortClomun)) {
            sql = sql + "order by " + sortClomun;
        }
        sql = this.addLimitToSql(sql, rowcount, pagesize, pageno);
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                LibConfig data = new LibConfig();
                data.setSeqid(rs.getLong("seqid"));
                data.setConfigno(rs.getString("configno"));
                data.setConfigname(rs.getString("configname"));
                data.setConfigvalue(rs.getString("configvalue"));
                data.setRemark(rs.getString("remark"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    @Deprecated
    public List<LibConfig> getLibConfigView(int rowcount, int pagesize, int pageno) {
        final ArrayList<LibConfig> datas = new ArrayList<LibConfig>();
        String sql = "select seqid,configno,configname,configvalue,remark from libconfig order by configno";
        sql = this.addLimitToSql(sql, rowcount, pagesize, pageno);
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                LibConfig data = new LibConfig();
                data.setSeqid(rs.getLong("seqid"));
                data.setConfigno(rs.getString("configno"));
                data.setConfigname(rs.getString("configname"));
                data.setConfigvalue(rs.getString("configvalue"));
                data.setRemark(rs.getString("remark"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    public Sheet<LibConfig> queryLibconfigs(LibConfig config, PagedFliper fliper) {
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (config != null) {
            if (this.isNotEmpty(config.getConfigno())) {
                where.append(" and configno = '").append(config.getConfigno()).append("'");
            }
            if (this.isNotEmpty(config.getConfigname())) {
                where.append(" and configname like '%" + config.getConfigname() + "%' ");
            }
        }
        String countsql = " select count(*) from libconfig ";
        int rowcount = super.getSingleInt(countsql = countsql + where.toString());
        if (rowcount == 0) {
            return Sheet.EMPTY;
        }
        String sql = "select * from libconfig ";
        sql = sql + where.toString();
        if (fliper != null) {
            if (fliper.isNotEmptySortColumn()) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet<LibConfig>(rowcount, this.query(LibConfig.class, sql, new String[0]));
    }

    @Override
    public int countLibconfigs(LibConfig config) {
        int rowcount = -1;
        if (config != null) {
            StringBuilder countsql = new StringBuilder("select count(1) from libconfig ");
            StringBuilder where = new StringBuilder(" where 1=1 ");
            if (this.isNotEmpty(config.getConfigno())) {
                where.append(" and configno='").append(config.getConfigno()).append("'");
            }
            if (config.getSeqid() > 0L) {
                where.append(" and seqid=").append(config.getSeqid());
            }
            if (this.isNotEmpty(config.getConfigname())) {
                where.append(" and configname='").append(config.getConfigname()).append("'");
            }
            rowcount = this.getSingleInt(countsql.append((CharSequence)where).toString());
        }
        return rowcount;
    }

    @Override
    public LibConfig getALibConfig(LibConfig libconfig) {
        return this.findObjectByCondition(libconfig);
    }

    @Override
    public List<LibConfig> getLibConfig(LibConfig libconfig) {
        return this.findObjects(libconfig, null, null);
    }
}

