/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.dao;

import com.xunlei.common.dao.IFunctionsDao;
import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.vo.Functions;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class FunctionsDaoImpl
extends JdbcBaseDao
implements IFunctionsDao {
    @Override
    public List<Functions> getAllFunctions() {
        String sql = "select * from functions  order by moduleno, funcno";
        return this.query(Functions.class, sql, new String[0]);
    }

    @Override
    @Deprecated
    public int getFunctionsViewCount(String moduleno) {
        String sql = "select count(*) from functions where moduleno = '" + moduleno + "' ";
        return super.getSingleInt(sql);
    }

    @Override
    @Deprecated
    public List<Functions> getFunctionsView(Functions function, String sortColumn, int rowcount, int pagesize, int pageno) {
        final ArrayList<Functions> datas = new ArrayList<Functions>();
        if (rowcount < 1) {
            return datas;
        }
        String sql = "select seqid,funcno,funcname,moduleno,haverun,haveadd,haveedit,havedel,haveplus from functions where moduleno = ? ";
        if (this.isNotEmpty(sortColumn)) {
            sql = sql + " order by " + sortColumn;
        }
        sql = this.addLimitToSql(sql, rowcount, pagesize, pageno);
        this.getJdbcTemplate().query(sql, (Object[])new String[]{function.getModuleno()}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Functions data = new Functions();
                data.setSeqid(rs.getLong("seqid"));
                data.setFuncno(rs.getString("funcno"));
                data.setFuncname(rs.getString("funcname"));
                data.setModuleno(rs.getString("moduleno"));
                data.setHaverun(rs.getShort("haverun"));
                data.setHaveadd(rs.getShort("haveadd"));
                data.setHaveedit(rs.getShort("haveedit"));
                data.setHavedel(rs.getShort("havedel"));
                data.setHaveplus(rs.getString("haveplus"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    @Deprecated
    public int getFunctionsViewCount(Functions function) {
        String sql = "select count(*) from functions where 1 ";
        if (this.isNotEmpty(function.getModuleno())) {
            sql = sql + " and moduleno = '" + function.getModuleno() + "' ";
        }
        if (function.getSplitplusopts().length > 0 && this.isNotEmpty(function.getSplitplusopts()[0])) {
            sql = sql + " and haveplus like '%" + function.getSplitplusopts()[0] + "%' ";
        }
        return super.getSingleInt(sql);
    }

    @Override
    @Deprecated
    public List<Functions> getFunctionsView(String moduleno, int rowcount, int pagesize, int pageno) {
        final ArrayList<Functions> datas = new ArrayList<Functions>();
        String sql = "select seqid,funcno,funcname,moduleno,haverun,haveadd,haveedit,havedel,haveplus from functions where moduleno = ? order by funcno";
        sql = this.addLimitToSql(sql, rowcount, pagesize, pageno);
        this.getJdbcTemplate().query(sql, (Object[])new String[]{moduleno}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                Functions data = new Functions();
                data.setSeqid(rs.getLong("seqid"));
                data.setFuncno(rs.getString("funcno"));
                data.setFuncname(rs.getString("funcname"));
                data.setModuleno(rs.getString("moduleno"));
                data.setHaverun(rs.getShort("haverun"));
                data.setHaveadd(rs.getShort("haveadd"));
                data.setHaveedit(rs.getShort("haveedit"));
                data.setHavedel(rs.getShort("havedel"));
                data.setHaveplus(rs.getString("haveplus"));
                datas.add(data);
            }
        });
        return datas;
    }

    @Override
    public Functions getAFunctions(Functions functions) {
        return this.findObjectByCondition(functions);
    }

    @Override
    public List<Functions> getFunctions(Functions functions) {
        return this.findObjects(functions, null, null);
    }

    @Override
    public Functions getFunctionsByMenuno(String menuno) {
        String sql = "select *  from functions as f, Menus as m where m.funcno = f.funcno and m.menuno = '" + StringTools.escapeSql(menuno) + "'";
        return this.queryOne(Functions.class, sql, new String[0]);
    }

    @Override
    public List<Functions> getFunctionsNotInRoles(String moduleno, String roleno) {
        String sql = "select * from functions as f where f.moduleno ='" + StringTools.escapeSql(moduleno) + "' and f.funcno not in (select " + "rr.funcno from rolerights as rr where rr.roleno ='" + StringTools.escapeSql(roleno) + "') order by f.funcno";
        return this.query(Functions.class, sql, new String[0]);
    }

    @Override
    public List<Functions> getFunctionsInRoles(String moduleno, String roleno) {
        String sql = "select * from functions as f where f.moduleno = '" + StringTools.escapeSql(moduleno) + "' and f.funcno in (select " + "rr.funcno from rolerights as rr where rr.roleno = '" + StringTools.escapeSql(roleno) + "') order by f.funcno ";
        return this.query(Functions.class, sql, new String[0]);
    }

    @Override
    public void insertFunctions(Functions data) {
        this.saveObject(data);
    }

    @Override
    public void updateFunctions(Functions data) {
        this.updateObject(data);
    }

    @Override
    public void removeFunctions(Functions data) {
        this.deleteObject(data);
    }

    @Override
    public Sheet<Functions> queryFunctions(Functions fun, PagedFliper fliper) {
        Sheet<Functions> sheet = this.findPagedObjects(fun, null, fliper);
        return sheet;
    }
}

