/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.bo;

import com.xunlei.common.bo.BaseBo;
import com.xunlei.common.bo.IRolesBo;
import com.xunlei.common.dao.IRolesDao;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.Roles;
import com.xunlei.common.vo.Users;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class RolesBoImpl
extends BaseBo
implements IRolesBo {
    @Autowired
    private IRolesDao rolesDao;

    public IRolesDao getRolesDao() {
        return this.rolesDao;
    }

    @Override
    public void setRolesDao(IRolesDao rolesDao) {
        this.rolesDao = rolesDao;
    }

    @Override
    public boolean authByRole(String funno, String operate, String[] roles) {
        return this.getRolesDao().authByRole(funno, operate, roles);
    }

    @Override
    public boolean isNotDataControlByRoles(String[] roles) {
        return this.getRolesDao().isNotDataControlByRoles(roles);
    }

    @Override
    public List<Roles> getAllRoles() {
        return this.getRolesDao().getAllRoles();
    }

    @Override
    public List<Roles> getAllSysRoles() {
        Roles r = new Roles();
        r.setRoletype("SYS");
        return this.getRolesDao().getRoles(r);
    }

    @Override
    public List<Roles> getAllRecRoles() {
        Roles r = new Roles();
        r.setRoletype("REC");
        return this.getRolesDao().getRoles(r);
    }

    @Override
    public Roles getRolesById(Long id) {
        Roles r = new Roles();
        r.setSeqid(id);
        return this.getRolesDao().getARoles(r);
    }

    private List<Roles> getSysRolesByRoleNo(String roleno) {
        Roles r = new Roles();
        r.setRoleno(roleno);
        r.setRoletype("SYS");
        return this.getRolesDao().getRoles(r);
    }

    private List<Roles> getSysRolesByRoleName(String rolename) {
        Roles r = new Roles();
        r.setRolename(rolename);
        r.setRoletype("SYS");
        return this.getRolesDao().getRoles(r);
    }

    private List<Roles> getRecRolesByRoleNo(String roleno) {
        Roles r = new Roles();
        r.setRoleno(roleno);
        r.setRoletype("REC");
        return this.getRolesDao().getRoles(r);
    }

    private List<Roles> getRecRolesByRoleName(String rolename) {
        Roles r = new Roles();
        r.setRolename(rolename);
        r.setRoletype("REC");
        return this.getRolesDao().getRoles(r);
    }

    @Override
    public void insertSysRoles(Roles data) {
        if (this.getSysRolesByRoleNo(data.getRoleno()).size() > 0) {
            throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u89d2\u8272");
        }
        if (this.getSysRolesByRoleName(data.getRolename()).size() > 0) {
            throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u7684\u89d2\u8272");
        }
        data.setRoletype("SYS");
        this.getRolesDao().insertRoles(data);
    }

    @Override
    public void updateSysRoles(Roles data) {
        Roles data1 = new Roles();
        data1.setRoleno(data.getRoleno());
        data1.setRoletype("SYS");
        List<Roles> datas = this.getRolesDao().getSysRolesByRoles(data1);
        if (datas.size() > 0 && (datas.size() > 1 || datas.get(0).getSeqid() != data.getSeqid())) {
            throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u89d2\u8272");
        }
        data1.setRoleno("");
        data1.setRolename(data.getRolename());
        datas = this.getRolesDao().getSysRolesByRoles(data1);
        if (datas.size() > 0 && (datas.size() > 1 || datas.get(0).getSeqid() != data.getSeqid())) {
            throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u7684\u89d2\u8272");
        }
        data.setRoletype("SYS");
        this.getRolesDao().updateRoles(data);
    }

    @Override
    public void removeSysRoles(Roles data) {
        this.removeSysRoles(data.getSeqid());
    }

    @Override
    public void removeSysRoles(long seqid) {
        Roles data = this.getRolesById(seqid);
        if (IFacadeCommon.INSTANCE.getRecordCount("usertorole", "cls.roletype = 'SYS' and cls.roleno = '" + data.getRoleno() + "'") > 0) {
            throw new XLRuntimeException("\u6b64\u89d2\u8272\u5df2\u88ab\u7528\u6237\u89d2\u8272\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        if (IFacadeCommon.INSTANCE.getRecordCount("rolerights", "cls.roleno = '" + data.getRoleno() + "'") > 0) {
            throw new XLRuntimeException("\u6b64\u89d2\u8272\u5df2\u88ab\u7cfb\u7edf\u6743\u9650\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        data.setRoletype("SYS");
        this.getRolesDao().removeRoles(data);
    }

    @Override
    public void insertRecRoles(Roles data) {
        if (this.getRecRolesByRoleNo(data.getRoleno()).size() > 0) {
            throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u89d2\u8272");
        }
        if (this.getRecRolesByRoleName(data.getRolename()).size() > 0) {
            throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u7684\u89d2\u8272");
        }
        data.setRoletype("REC");
        this.getRolesDao().insertRoles(data);
    }

    @Override
    public void updateRecRoles(Roles data) {
        Roles data1 = new Roles();
        data1.setRoleno(data.getRoleno());
        data1.setRoletype("REC");
        List<Roles> datas = this.getRolesDao().getSysRolesByRoles(data1);
        if (datas.size() > 0 && (datas.size() > 1 || datas.get(0).getSeqid() != data.getSeqid())) {
            throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u89d2\u8272");
        }
        data1.setRoleno("");
        data1.setRolename(data.getRolename());
        datas = this.getRolesDao().getSysRolesByRoles(data1);
        if (datas.size() > 0 && (datas.size() > 1 || datas.get(0).getSeqid() != data.getSeqid())) {
            throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u7684\u89d2\u8272");
        }
        data.setRoletype("REC");
        this.getRolesDao().updateRoles(data);
    }

    @Override
    public void removeRecRoles(Roles data) {
        this.removeRecRoles(data.getSeqid());
    }

    @Override
    public void removeRecRoles(long seqid) {
        Roles data = this.getRolesById(seqid);
        if (IFacadeCommon.INSTANCE.getRecordCount("usertorole", "cls.roletype = 'REC' and cls.roleno = '" + data.getRoleno() + "'") > 0) {
            throw new XLRuntimeException("\u6b64\u89d2\u8272\u5df2\u88ab\u7528\u6237\u89d2\u8272\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        data.setRoletype("REC");
        this.getRolesDao().removeRoles(data);
    }

    @Override
    @Deprecated
    public int getSysRolesViewCount(Roles role) {
        return this.getRolesDao().getSysRolesViewCount(role);
    }

    @Override
    @Deprecated
    public List<Roles> getSysRolesView(Roles role, String sortColumn, int rowcount, int pagesize, int pageno) {
        return this.getRolesDao().getSysRolesView(role, sortColumn, rowcount, pagesize, pageno);
    }

    @Override
    @Deprecated
    public int getRecRolesViewCount(Roles role) {
        return this.getRolesDao().getRecRolesViewCount(role);
    }

    @Override
    @Deprecated
    public List<Roles> getRecRolesView(Roles role, String sortColumn, int rowcount, int pagesize, int pageno) {
        return this.getRolesDao().getRecRolesView(role, sortColumn, rowcount, pagesize, pageno);
    }

    @Override
    public Sheet<Roles> querySysRoles(Roles roles, PagedFliper fliper) {
        return this.getRolesDao().querySysRoles(roles, fliper);
    }

    @Override
    public Sheet<Roles> queryRecRoles(Roles roles, PagedFliper fliper) {
        return this.getRolesDao().queryRecRoles(roles, fliper);
    }

    @Override
    public List<Roles> getAllRolesInUsers(Users u) {
        return this.getRolesDao().getAllRolesInUsers(u);
    }

    @Override
    public List<Roles> getAllRolesNotInUsers(Users u) {
        return this.getRolesDao().getAllRolesNotInUsers(u);
    }
}

