/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.bo;

import com.xunlei.common.bo.BaseBo;
import com.xunlei.common.bo.IRoleRightsBo;
import com.xunlei.common.dao.IRoleRightsDao;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.RoleRights;
import com.xunlei.common.vo.Users;
import com.xunlei.common.web.bean.OperatEntry;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class RoleRightsBoImpl
extends BaseBo
implements IRoleRightsBo {
    @Autowired
    private IRoleRightsDao roleRightsDao;

    public IRoleRightsDao getRoleRightsDao() {
        return this.roleRightsDao;
    }

    @Override
    public void setRoleRightsDao(IRoleRightsDao roleRightsDao) {
        this.roleRightsDao = roleRightsDao;
    }

    @Override
    public List<RoleRights> getAllRoleRights() {
        return this.getRoleRightsDao().getRoleRights(new RoleRights());
    }

    @Override
    public RoleRights getRoleRightsById(Long id) {
        RoleRights rr = new RoleRights();
        rr.setSeqid(id);
        return this.getRoleRightsDao().getARoleRights(rr);
    }

    @Override
    public void insertRoleRights(RoleRights data) {
        this.getRoleRightsDao().insertRoleRights(data);
    }

    @Override
    public void updateRoleRights(RoleRights data) {
        this.getRoleRightsDao().updateRoleRights(data);
    }

    @Override
    public void removeRoleRights(RoleRights data) {
        this.removeRoleRights(data.getSeqid());
    }

    @Override
    public void removeRoleRights(long seqid) {
        RoleRights data = this.getRoleRightsById(seqid);
        this.getRoleRightsDao().removeRoleRights(data);
    }

    @Override
    public List<RoleRights> getRoleRightsByRoleNo(String roleno) {
        RoleRights rr = new RoleRights();
        rr.setRoleno(roleno);
        return this.getRoleRightsDao().getRoleRights(rr);
    }

    @Override
    public RoleRights getRoleRightsByRoleNoAndFuncNo(String roleno, String funcno) {
        RoleRights rr = new RoleRights();
        rr.setRoleno(roleno);
        rr.setFuncno(funcno);
        return this.getRoleRightsDao().getARoleRights(rr);
    }

    @Override
    public List<RoleRights> getRoleRightsByRoleNoAndModuleNo(String roleno, String moduleno, String sortColumn) {
        List<RoleRights> list = this.getRoleRightsDao().getRoleRightsByRoleNoAndModuleNo(roleno, moduleno, sortColumn);
        for (RoleRights rr : list) {
            rr.setAllpluses(OperatEntry.transfer(IFacadeCommon.INSTANCE.getAllPlusOperation()));
        }
        return list;
    }

    @Override
    public List<RoleRights> getRoleRightsByUserAndModuleNo(Users user, String moduleno, String sortColumn) {
        return this.getRoleRightsDao().getRoleRightsByUserAndModuleNo(user, moduleno, sortColumn);
    }

    @Override
    public List<LibClassD> getModelNoByUser(Users user) {
        return this.getRoleRightsDao().getModelNoByUser(user);
    }

    @Override
    public List<RoleRights> getRoleRightsBySubuserAndModuleNo(Users user, String moduleno, String sortColumn) {
        return this.getRoleRightsDao().getRoleRightsBySubuserAndModuleNo(user, moduleno, sortColumn);
    }

    @Override
    public List<RoleRights> getRoleRightsByRoleList(String[] roles) {
        return this.getRoleRightsDao().getRoleRightsByRoleList(roles);
    }

    @Override
    public List<RoleRights> getUserrights(Users user, String currModuleNo, String sortColumn) {
        Users subuser = IFacadeCommon.INSTANCE.findAUsers(user);
        if (subuser != null && StringTools.isNotEmpty(subuser.getUpuserlogno())) {
            return this.getRoleRightsBySubuserAndModuleNo(user, currModuleNo, sortColumn);
        }
        return this.getRoleRightsByUserAndModuleNo(user, currModuleNo, sortColumn);
    }
}

