/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.bo;

import com.xunlei.common.bo.IPlacardsBo;
import com.xunlei.common.dao.IPlacardsDao;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.ApplicationConfigUtil;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.Placards;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class PlacardsBoImpl
implements IPlacardsBo {
    private static Logger logger = Logger.getLogger(PlacardsBoImpl.class);
    @Autowired
    private IPlacardsDao placardsDaoImpl;

    @Override
    public Placards getPlacardsById(long seqid) {
        return this.placardsDaoImpl.getPlacardsById(seqid);
    }

    @Override
    public Placards insertPlacards(Placards data) {
        Sheet<Placards> sheet;
        Placards searchobj = new Placards();
        searchobj.setSerialid(data.getSerialid());
        searchobj.setSerialnum(data.getSerialnum());
        searchobj.setQueryserialnumtype(1);
        if (StringTools.isNotEmpty(data.getSerialid()) && (sheet = this.placardsDaoImpl.queryPlacards(searchobj, null)).getRowcount() > 0) {
            throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u8fde\u8f7d\u987a\u5e8f");
        }
        return this.placardsDaoImpl.insertPlacards(data);
    }

    @Override
    public void updatePlacards(Placards data) {
        Sheet<Placards> sheet;
        Placards searchobj = new Placards();
        searchobj.setSerialid(data.getSerialid());
        searchobj.setSerialnum(data.getSerialnum());
        searchobj.setQueryserialnumtype(1);
        if (StringTools.isNotEmpty(data.getSerialid()) && (sheet = this.placardsDaoImpl.queryPlacards(searchobj, null)).getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            for (Placards p : list) {
                if (p.getSeqid() == data.getSeqid()) continue;
                throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u8fde\u8f7d\u987a\u5e8f");
            }
        }
        this.placardsDaoImpl.updatePlacards(data);
    }

    @Override
    public void deleteSoft(long seqid, String type) {
        Placards data = this.getPlacardsById(seqid);
        if (type.equals("R")) {
            data.setDeleted((short)0);
        } else if (type.equals("D")) {
            data.setDeleted((short)1);
        }
        this.updatePlacards(data);
    }

    @Override
    public void deletePlacardsById(long seqid) {
        Placards data = IFacadeCommon.INSTANCE.getPlacardsById(seqid);
        if (data != null && StringTools.isNotEmpty(data.getPicurl())) {
            this.deleteFile(data);
        }
        this.placardsDaoImpl.deletePlacardsById(seqid);
    }

    private void deleteFile(Placards data) {
        String filename = data.getPicurl();
        String path = ApplicationConfigUtil.getRootFilePath() + "upload" + File.separator + data.getFlatno() + File.separator + "placards" + File.separator + "images" + File.separator;
        logger.debug("path=" + path);
        if (filename == null || filename.equals("")) {
            return;
        }
        File file = new File(path + filename);
        File file2 = new File(path + "b_" + filename);
        if (!file.exists()) {
            logger.debug("\u6587\u4ef6\u4e0d\u5b58\u5728,\u5220\u9664\u5931\u8d25!");
        } else {
            file.delete();
            file2.delete();
            logger.debug("\u5220\u9664\u6210\u529f!");
        }
    }

    @Override
    public void deletePlacards(Placards data) {
        this.placardsDaoImpl.deletePlacards(data);
    }

    @Override
    public Sheet<Placards> queryPlacards(Placards data, PagedFliper fliper) {
        return this.placardsDaoImpl.queryPlacards(data, fliper);
    }

    @Override
    public int getMaxserialnum(String serialid) {
        return this.placardsDaoImpl.getMaxserialnum(serialid);
    }
}

