/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.bo;

import com.xunlei.common.bo.BaseBo;
import com.xunlei.common.bo.IFunctionsBo;
import com.xunlei.common.dao.IFunctionsDao;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.Functions;
import com.xunlei.common.web.bean.OperatEntry;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class FunctionsBoImpl
extends BaseBo
implements IFunctionsBo {
    @Autowired
    private IFunctionsDao functionsDao;

    public IFunctionsDao getFunctionsDao() {
        return this.functionsDao;
    }

    @Override
    public void setFunctionsDao(IFunctionsDao functionsDao) {
        this.functionsDao = functionsDao;
    }

    @Override
    public List<Functions> getAllFunctions() {
        return this.getFunctionsDao().getAllFunctions();
    }

    @Override
    public Functions getFunctionsById(Long id) {
        Functions f = new Functions();
        f.setSeqid(id);
        return this.getFunctionsDao().getAFunctions(f);
    }

    @Override
    @Deprecated
    public List<Functions> getFunctionsView(Functions function, String sortColumn, int rowcount, int pagesize, int pageno) {
        return this.getFunctionsDao().getFunctionsView(function, sortColumn, rowcount, pagesize, pageno);
    }

    @Override
    @Deprecated
    public int getFunctionsViewCount(Functions function) {
        return this.getFunctionsDao().getFunctionsViewCount(function);
    }

    @Override
    public Functions getFunctionsByMenuno(String menuno) {
        return this.getFunctionsDao().getFunctionsByMenuno(menuno);
    }

    @Override
    public List<Functions> getFunctionsByFuncNo(String funcno) {
        Functions f = new Functions();
        f.setFuncno(funcno);
        return this.getFunctionsDao().getFunctions(f);
    }

    private List<Functions> getFunctionsByFuncName(String funcname) {
        Functions f = new Functions();
        f.setFuncname(funcname);
        return this.getFunctionsDao().getFunctions(f);
    }

    @Override
    public List<Functions> getFunctionsByModuleNo(String moduleno) {
        Functions f = new Functions();
        f.setModuleno(moduleno);
        return this.getFunctionsDao().getFunctions(f);
    }

    @Override
    public List<Functions> getFunctionsInRoles(String moduleno, String roleno) {
        return this.getFunctionsDao().getFunctionsInRoles(moduleno, roleno);
    }

    @Override
    public List<Functions> getFunctionsNotInRoles(String moduleno, String roleno) {
        List<Functions> list = this.getFunctionsDao().getFunctionsNotInRoles(moduleno, roleno);
        for (Functions func : list) {
            func.setAllpluses(OperatEntry.transfer(IFacadeCommon.INSTANCE.getAllPlusOperation()));
        }
        return list;
    }

    @Override
    public void insertFunctions(Functions data) {
        if (this.getFunctionsByFuncNo(data.getFuncno()).size() > 0) {
            throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u6a21\u5757");
        }
        List<Functions> datas = this.getFunctionsByFuncName(data.getFuncname());
        if (datas.size() > 0) {
            for (int i = 0; i < datas.size(); ++i) {
                if (!datas.get(i).getModuleno().equals(data.getModuleno())) continue;
                throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u7684\u6a21\u5757");
            }
        }
        this.getFunctionsDao().insertFunctions(data);
    }

    @Override
    public void updateFunctions(Functions data) {
        Functions data1 = new Functions();
        data1.setFuncno(data.getFuncno());
        List<Functions> datas = this.getFunctionsDao().getFunctions(data1);
        if (datas.size() > 0 && (datas.size() > 1 || datas.get(0).getSeqid() != data.getSeqid())) {
            throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u6a21\u5757");
        }
        data1.setFuncno("");
        data1.setFuncname(data.getFuncname());
        datas = this.getFunctionsDao().getFunctions(data1);
        if (datas.size() > 0) {
            for (int i = 0; i < datas.size(); ++i) {
                if (!datas.get(i).getModuleno().equals(data.getModuleno()) || datas.get(i).getSeqid() == data.getSeqid()) continue;
                throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u7684\u6a21\u5757");
            }
        }
        this.getFunctionsDao().updateFunctions(data);
    }

    @Override
    public void removeFunctions(Functions data) {
        data = this.getFunctionsById(data.getSeqid());
        if (IFacadeCommon.INSTANCE.getRecordCount("menus", "cls.funcno = '" + data.getFuncno() + "'") > 0) {
            throw new XLRuntimeException("\u6b64\u6a21\u5757\u5df2\u88ab\u7cfb\u7edf\u83dc\u5355\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        if (IFacadeCommon.INSTANCE.getRecordCount("rolerights", "cls.funcno = '" + data.getFuncno() + "'") > 0) {
            throw new XLRuntimeException("\u6b64\u6a21\u5757\u5df2\u88ab\u7cfb\u7edf\u6743\u9650\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.getFunctionsDao().removeFunctions(data);
    }

    @Override
    @Deprecated
    public List<Functions> getFunctionsView(String moduleno, int rowcount, int pagesize, int pageno) {
        return this.getFunctionsDao().getFunctionsView(moduleno, rowcount, pagesize, pageno);
    }

    @Override
    @Deprecated
    public int getFunctionsViewCount(String moduleno) {
        return this.getFunctionsDao().getFunctionsViewCount(moduleno);
    }

    @Override
    public Sheet<Functions> queryFunctions(Functions fun, PagedFliper fliper) {
        Sheet<Functions> sheet = this.getFunctionsDao().queryFunctions(fun, fliper);
        for (Functions func : sheet.getDatas()) {
            func.setAllpluses(OperatEntry.transfer(IFacadeCommon.INSTANCE.getAllPlusOperation()));
        }
        return sheet;
    }
}

