/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.util;

import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.channel.util.PropertiesReader;
import com.xunlei.channel.util.VIPNumberUtil;
import com.xunlei.channel.util.WebAuthCode;
import com.xunlei.channel.vo.AuthIdCard;
import com.xunlei.channel.vo.BindMobile;
import com.xunlei.channel.vo.CheckPassProxy;
import com.xunlei.channel.vo.SecureMail;
import com.xunlei.channel.vo.UserEntitry;
import com.xunlei.channel.vo.VIPInfo;
import com.xunlei.channel.vo.WebAuthResult;
import com.xunlei.channel.vo.Xlnumber;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.http.VipProxy;
import com.xunlei.proxy.socket.LoginProxy;
import com.xunlei.proxy.socket.UserInfoProxy;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_base;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_sec;
import com.xunlei.proxy.socket.bin.resp.Resp_getusrinfor;
import com.xunlei.proxy.socket.bin.resp.Resp_id2name;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class UserUtility {
    private static final Log logger = LogFactory.getLog(UserUtility.class);
    private static UserInfoProxy userInfoProxy = null;
    private static LoginProxy loginProxy = null;
    private static VipProxy vipProxy = null;
    private static List<String> webAuthUrls;
    private static int httpConnectionTimeout;
    private static int httpSocketTimeout;
    private static PropertiesReader pu;
    private static final Pattern pnumber;
    private static final DateFormat format;

    private static void initateWebAuthConfig() {
        webAuthUrls = new ArrayList<String>();
        httpConnectionTimeout = 5000;
        try {
            String[] urls;
            pu = new PropertiesReader("xlchannelusersrv.properties");
            for (String url : urls = pu.getProperty("auth.webAuthUrls").split(",")) {
                webAuthUrls.add(url);
            }
            httpConnectionTimeout = Integer.parseInt(pu.getProperty("auth.httpConnectionTimeout"));
            httpSocketTimeout = Integer.parseInt(pu.getProperty("auth.httpSocketTimout"));
        }
        catch (IOException e) {
            logger.error(e);
        }
    }

    public static String getUserIdByUserName(String userName) {
        String userid = null;
        try {
            Resp_getuserinfo_base userInfo = userInfoProxy.getuserinfo_base(userName, (byte)-1);
            if (userInfo.isOk()) {
                userid = String.valueOf(userInfo.getUserno());
            }
        }
        catch (Exception e) {
            logger.error("getUserIdByUserName exception:" + e);
            throw new XLRuntimeException(e);
        }
        return userid;
    }

    public static String getUserNameByUserId(String userId) {
        String userName = null;
        try {
            Resp_getuserinfo_base userInfo = userInfoProxy.getuserinfo_base(userId, (byte)2);
            if (userInfo.isOk()) {
                String oldUserName = userInfo.getUsrname();
                String newUserName = userInfo.getUsernewno() + "";
                String accountType = String.valueOf(userInfo.getUsertype());
                userName = accountType.equals("1") ? newUserName : oldUserName;
            }
        }
        catch (Exception e) {
            logger.error("getUserNameByUserId Exception:" + e);
            throw new XLRuntimeException(e);
        }
        return userName;
    }

    public static UserEntitry getUserEntitryByUserName(String userName) {
        UserEntitry entitry = null;
        try {
            Resp_getuserinfo_base userInfo = userInfoProxy.getuserinfo_base(userName, (byte)-1);
            if (userInfo.isOk()) {
                entitry = new UserEntitry();
                entitry.setUserid(String.valueOf(userInfo.getUserno()));
                entitry.setUsername(userName);
                entitry.setNewaccount(userInfo.getUsernewno());
                entitry.setOldaccount(userInfo.getUsrname());
                entitry.setNickname(userInfo.getNickname());
                entitry.setVip(String.valueOf(userInfo.getState()));
                if (userName.equals(entitry.getOldaccount())) {
                    entitry.setAccounttype((byte)0);
                } else {
                    entitry.setAccounttype((byte)1);
                }
            }
        }
        catch (Exception e) {
            logger.error("getUserEntitryByUserName exception:" + e);
            throw new XLRuntimeException(e);
        }
        return entitry;
    }

    public static boolean isNumber(String s) {
        if (s == null || s.equals("")) {
            return false;
        }
        Matcher m = pnumber.matcher(s);
        return m.matches();
    }

    public static String getUserNumidByUserName(String userName, String usertype) {
        String numId = null;
        try {
            Resp_getuserinfo_base userInfo = userInfoProxy.getuserinfo_base(userName, new Byte(usertype));
            if (userInfo.isOk()) {
                numId = String.valueOf(userInfo.getUserno());
            }
        }
        catch (Exception e) {
            logger.error("getUserNumidByUserName exception:" + e);
            throw new XLRuntimeException(e);
        }
        return numId;
    }

    public static UserEntitry getUsrSessioninfo(String sessionId) {
        UserEntitry entitry = null;
        try {
            Resp_getusrinfor loginInfo = loginProxy.getusrinfor(sessionId);
            logger.info("loginInfo result:" + loginInfo.getResult() + ",isOk = " + loginInfo.isOk() + ",username = " + loginInfo.getUsername());
            if (loginInfo.isOk()) {
                long userno = loginInfo.getUserno();
                String username = UserUtility.getUserNameByUserId(userno + "");
                entitry = UserUtility.getUserEntitryByUserName(username);
            }
        }
        catch (Exception e) {
            logger.error("getUsrSessioninfo exception:" + e);
            throw new XLRuntimeException(e);
        }
        return entitry;
    }

    public static boolean isUserExists(String userName) {
        boolean exists = false;
        try {
            Resp_getuserinfo_base userInfo = userInfoProxy.getuserinfo_base(userName, (byte)-1);
            exists = userInfo.isOk();
        }
        catch (Exception e) {
            logger.error("isUserExists exception:" + e);
            throw new XLRuntimeException(e);
        }
        return exists;
    }

    public static int queryVIPUser(String userName, boolean isNewUser) {
        int level = 0;
        try {
            String userId = UserUtility.getUserIdByUserName(userName);
            VipProxy.VipState userInfo = vipProxy.getVipState(Long.parseLong(userId));
            level = null != userInfo ? userInfo.getLevel() : 0;
        }
        catch (Exception e) {
            logger.error("queryVIPUser exception:" + e);
            throw new XLRuntimeException(e);
        }
        return level;
    }

    public static int queryVIPUser(String userName) {
        int level = 0;
        try {
            String userId = UserUtility.getUserIdByUserName(userName);
            VipProxy.VipState userInfo = vipProxy.getVipState(Long.parseLong(userId));
            level = null != userInfo ? userInfo.getLevel() : 0;
        }
        catch (Exception e) {
            logger.error("queryVIPUser exception:" + e);
            throw new XLRuntimeException(e);
        }
        return level;
    }

    public static WebAuthResult authUsingPassword(String userAccount, String userPassword, String verifyCode, String verifyKey, String sourceNo, String clientIp, String userAgent) {
        return UserUtility.authUsingPassword(userAccount, userPassword, verifyCode, verifyKey);
    }

    public static WebAuthResult authUsingPassword(String userName, String password, String verifyCode, String verifyKey) {
        WebAuthResult result = new WebAuthResult();
        result.setSuccess(false);
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            HttpResponse response = null;
            for (String url : webAuthUrls) {
                try {
                    StatusLine status;
                    int statusCode;
                    HttpPost post = new HttpPost(url);
                    post.setHeader("Cookie", "VERIFY_KEY=" + verifyKey);
                    ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                    nvps.add(new BasicNameValuePair("u", userName));
                    nvps.add(new BasicNameValuePair("p", Md5Encrypt.md5(Md5Encrypt.md5(password))));
                    nvps.add(new BasicNameValuePair("verifycode", verifyCode));
                    post.setEntity(new UrlEncodedFormEntity(nvps, "UTF-8"));
                    if (httpConnectionTimeout > 0) {
                        client.getParams().setParameter("http.connection.timeout", httpConnectionTimeout);
                    }
                    if (httpSocketTimeout > 0) {
                        client.getParams().setParameter("http.socket.timeout", 60000);
                    }
                    if ((statusCode = (status = (response = client.execute(post)).getStatusLine()).getStatusCode()) != 200) {
                        logger.warn("Request " + url + ", statusCode: " + statusCode);
                        continue;
                    }
                    List<Cookie> cookies = client.getCookieStore().getCookies();
                    if (null != cookies && cookies.size() > 0) {
                        HashMap<String, String> cookiesMap = new HashMap<String, String>();
                        for (Cookie cookie : cookies) {
                            cookiesMap.put(cookie.getName(), cookie.getValue());
                        }
                        String blogresult = (String)cookiesMap.get("blogresult");
                        logger.debug("Web Auth Server blogresult: " + blogresult);
                        if (blogresult != null) {
                            if (blogresult.equals("0")) {
                                result.setSuccess(true);
                                result.setAccountType(new Byte((String)cookiesMap.get("usertype")));
                                result.setDigitAccount((String)cookiesMap.get("usernewno"));
                                result.setOldAccount((String)cookiesMap.get("usrname"));
                                result.setStateCode((String)cookiesMap.get("sessionid"));
                                result.setUserId((String)cookiesMap.get("userid"));
                                result.setNickName((String)cookiesMap.get("nickname"));
                                result.setVip((String)cookiesMap.get("isvip"));
                            } else {
                                if (blogresult.equals("3") || blogresult.equals("7") || blogresult.equals("8") || blogresult.equals("12")) {
                                    logger.warn("Request: " + url + ",Return blogresult: " + WebAuthCode.getMsgByCode(blogresult));
                                    continue;
                                }
                                result = new WebAuthResult();
                                result.setSuccess(false);
                                result.setMsg(WebAuthCode.getMsgByCode(blogresult));
                            }
                            break;
                        }
                        logger.warn("No correct result returned, request URL: " + url);
                        continue;
                    }
                    logger.warn("No result from server, request URL: " + url);
                }
                catch (ClientProtocolException e) {
                    logger.warn("Request: " + url + ", Exception: " + e);
                }
                catch (IOException e) {
                    logger.warn("Request: " + url + ", Exception: " + e);
                }
            }
        }
        catch (Exception e) {
            logger.error("Auth exception:" + e);
        }
        return result;
    }

    public static SecureMail getSecMailByUserid(String userid) {
        SecureMail secureMail = new SecureMail();
        String mail = "";
        String mail_status = "";
        Resp_getuserinfo_sec userinfo_sec = UserUtility.getUserInfoProxyByUserid(userid);
        if (userinfo_sec == null) {
            return secureMail;
        }
        mail_status = userinfo_sec.getMail_status();
        mail = userinfo_sec.getMail();
        secureMail.setMail(mail);
        secureMail.setMail_status(mail_status);
        logger.info("userid: " + userid + ", " + secureMail.toString());
        return secureMail;
    }

    public static SecureMail getSecMailByUserName(String userName) {
        SecureMail secureMail = new SecureMail();
        String mail = "";
        String mail_status = "";
        Resp_getuserinfo_sec userinfo_sec = UserUtility.getUserInfoProxyByUserName(userName);
        if (userinfo_sec == null) {
            return secureMail;
        }
        mail_status = userinfo_sec.getMail_status();
        mail = userinfo_sec.getMail();
        secureMail.setMail(mail);
        secureMail.setMail_status(mail_status);
        logger.info("userName: " + userName + ", " + secureMail.toString());
        return secureMail;
    }

    public static int getPassGenerationByUserid(String userid) {
        int generation = 0;
        Resp_getuserinfo_sec userinfo_sec = UserUtility.getUserInfoProxyByUserid(userid);
        if (userinfo_sec == null) {
            return generation;
        }
        generation = UserUtility.isNotEmpty(userinfo_sec.getAnswer1()) && UserUtility.isNotEmpty(userinfo_sec.getAnswer2()) && UserUtility.isNotEmpty(userinfo_sec.getAnswer3()) ? 2 : (UserUtility.isEmpty(userinfo_sec.getAnswer1()) && UserUtility.isEmpty(userinfo_sec.getAnswer2()) && UserUtility.isEmpty(userinfo_sec.getAnswer3()) ? 0 : 1);
        return generation;
    }

    public static boolean judgePayAnswer(String userid, int index, String payAnswer) {
        boolean answerFlag = false;
        Resp_getuserinfo_sec userinfo_sec = UserUtility.getUserInfoProxyByUserid(userid);
        if (userinfo_sec == null) {
            return false;
        }
        switch (index) {
            case 1: {
                logger.info("payAnswer is " + payAnswer + " and Answer1 is " + userinfo_sec.getAnswer1());
                if (!userinfo_sec.getAnswer1().equals(payAnswer)) break;
                answerFlag = true;
                break;
            }
            case 2: {
                logger.info("payAnswer is " + payAnswer + " and Answer2 is " + userinfo_sec.getAnswer2());
                if (!userinfo_sec.getAnswer2().equals(payAnswer)) break;
                answerFlag = true;
                break;
            }
            case 3: {
                logger.info("payAnswer is " + payAnswer + " and Answer3 is " + userinfo_sec.getAnswer3());
                if (!userinfo_sec.getAnswer3().equals(payAnswer)) break;
                answerFlag = true;
                break;
            }
            default: {
                logger.info("The index is null");
                return false;
            }
        }
        return answerFlag;
    }

    public static String findAnswer(String username, int index, String payAnswer) {
        Resp_getuserinfo_sec userinfo_sec = UserUtility.getUserInfoProxyByUserName(username);
        if (userinfo_sec == null) {
            return null;
        }
        switch (index) {
            case 1: {
                logger.info("payAnswer is " + payAnswer + " and Answer1 is " + userinfo_sec.getAnswer1());
                return userinfo_sec.getAnswer1();
            }
            case 2: {
                logger.info("payAnswer is " + payAnswer + " and Answer2 is " + userinfo_sec.getAnswer2());
                return userinfo_sec.getAnswer2();
            }
            case 3: {
                logger.info("payAnswer is " + payAnswer + " and Answer3 is " + userinfo_sec.getAnswer3());
                return userinfo_sec.getAnswer3();
            }
        }
        logger.info("The index is null");
        return null;
    }

    public static String[] findQuestions(String userid) {
        Resp_getuserinfo_sec userinfo_sec = UserUtility.getUserInfoProxyByUserid(userid);
        String[] str = new String[]{userinfo_sec.getQuestion1(), userinfo_sec.getQuestion2(), userinfo_sec.getQuestion3()};
        return str;
    }

    public static int getPassGenerationByUserName(String userName) {
        int generation = 0;
        Resp_getuserinfo_sec userinfo_sec = UserUtility.getUserInfoProxyByUserName(userName);
        if (userinfo_sec == null) {
            return generation;
        }
        generation = UserUtility.isNotEmpty(userinfo_sec.getAnswer1()) && UserUtility.isNotEmpty(userinfo_sec.getAnswer2()) && UserUtility.isNotEmpty(userinfo_sec.getAnswer3()) ? 2 : (UserUtility.isEmpty(userinfo_sec.getAnswer1()) && UserUtility.isEmpty(userinfo_sec.getAnswer2()) && UserUtility.isEmpty(userinfo_sec.getAnswer3()) ? 0 : 1);
        return generation;
    }

    public static String getRegisterdateByUserName(String userName) {
        Resp_getuserinfo_sec userinfo_sec = UserUtility.getUserInfoProxyByUserName(userName);
        if (userinfo_sec == null) {
            return "";
        }
        if (UserUtility.isEmpty(userinfo_sec.getRegisterdate())) {
            return "";
        }
        String time = userinfo_sec.getRegisterdate();
        return format.format(new Date(Long.parseLong(time + "000")));
    }

    public static String getRegisterdateByUserid(String userid) {
        Resp_getuserinfo_sec userinfo_sec = UserUtility.getUserInfoProxyByUserid(userid);
        if (userinfo_sec == null) {
            return "";
        }
        String time = userinfo_sec.getRegisterdate();
        return format.format(new Date(Long.parseLong(time + "000")));
    }

    public static Resp_getuserinfo_sec getUserInfoProxyByUserName(String userName) {
        try {
            Resp_getuserinfo_sec userinfo_sec = userInfoProxy.getuserinfo_sec(userName, (byte)-1);
            logger.debug(UserUtility.userinfo_sec2String(userinfo_sec));
            if (userinfo_sec.isOk()) {
                return userinfo_sec;
            }
        }
        catch (Exception e) {
            logger.error("getPassGeneration error..." + e.getMessage());
            throw new XLRuntimeException();
        }
        return null;
    }

    public static Resp_getuserinfo_sec getUserInfoProxyByUserid(String userid) {
        try {
            Resp_getuserinfo_sec userinfo_sec = userInfoProxy.getuserinfo_sec(userid, (byte)2);
            logger.debug(UserUtility.userinfo_sec2String(userinfo_sec));
            if (userinfo_sec.isOk()) {
                return userinfo_sec;
            }
        }
        catch (Exception e) {
            logger.error("getPassGeneration error..." + e.getMessage());
            throw new XLRuntimeException();
        }
        return null;
    }

    public static AuthIdCard getAuthIdCardByUserid(String userid) {
        AuthIdCard idCard = new AuthIdCard();
        Resp_getuserinfo_sec userinfo_sec = UserUtility.getUserInfoProxyByUserid(userid);
        String idcard = userinfo_sec.getIdcardno();
        if (idcard != null) {
            idCard.setHasAuth(true);
            idCard.setIdcard(idcard);
            idCard.setTruename(userinfo_sec.getTruename());
        }
        return idCard;
    }

    public static AuthIdCard getAuthIdCardByUserName(String userName) {
        AuthIdCard idCard = new AuthIdCard();
        Resp_getuserinfo_sec userinfo_sec = UserUtility.getUserInfoProxyByUserName(userName);
        String idcard = userinfo_sec.getIdcardno();
        if (idcard != null) {
            idCard.setHasAuth(true);
            idCard.setIdcard(idcard);
        }
        return idCard;
    }

    public static BindMobile getBindMobileByUserid(String userid) {
        BindMobile bindMobile = new BindMobile();
        Map<Byte, String> nametype2nameMap = UserUtility.getNametype2nameMapByUserid(userid);
        if (nametype2nameMap == null || nametype2nameMap.size() == 0) {
            return null;
        }
        String mobile = nametype2nameMap.get((byte)5);
        if (mobile != null && !mobile.isEmpty()) {
            bindMobile.setBand(true);
            bindMobile.setMobile(mobile);
        }
        return bindMobile;
    }

    public static BindMobile getBindMobileByUserName(String userName) {
        BindMobile bindMobile = new BindMobile();
        Map<Byte, String> nametype2nameMap = UserUtility.getNametype2nameMapByUserName(userName);
        if (nametype2nameMap == null || nametype2nameMap.size() == 0) {
            return bindMobile;
        }
        String mobile = nametype2nameMap.get((byte)5);
        if (mobile != null && !mobile.isEmpty()) {
            bindMobile.setBand(true);
            bindMobile.setMobile(mobile);
        }
        return bindMobile;
    }

    private static Map<Byte, String> getNametype2nameMapByUserid(String userid) {
        try {
            Resp_id2name id2name = userInfoProxy.id2name(userid, (byte)2, (byte)-1);
            if (id2name.isOk()) {
                Map<Byte, String> nametype2nameMap = id2name.getNametype2name();
                logger.debug("nametype2nameMap : " + UserUtility.nametype2nameMap2String(nametype2nameMap));
                return nametype2nameMap;
            }
        }
        catch (Exception e) {
            logger.error("getMobileBind error..." + e.getMessage());
            throw new XLRuntimeException();
        }
        return null;
    }

    private static Map<Byte, String> getNametype2nameMapByUserName(String userName) {
        try {
            Resp_id2name id2name = userInfoProxy.id2name(userName, (byte)-1, (byte)-1);
            if (id2name.isOk()) {
                Map<Byte, String> nametype2nameMap = id2name.getNametype2name();
                logger.debug("nametype2nameMap : " + UserUtility.nametype2nameMap2String(nametype2nameMap));
                return nametype2nameMap;
            }
        }
        catch (Exception e) {
            logger.error("getMobileBind error..." + e.getMessage());
            throw new XLRuntimeException();
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println();
        System.out.println(UserUtility.authUsingPassByUsername("xlchannel", "abc333333"));
        System.out.println(UserUtility.authUsingPassByUserid("69551120", "abc333333"));
        System.out.println(UserUtility.authUsingPassByUsername("betatong", "333333"));
        System.out.println(UserUtility.authUsingPassByUserid("28476250", "333333"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WebAuthResult authUsingStateCode(String userAccount, String stateCode, String sourceNo, String clientIp, String userAgent) {
        WebAuthResult rtnresult = null;
        try {
            Resp_getusrinfor loginInfo = loginProxy.getusrinfor(stateCode);
            if (!loginInfo.isOk()) {
                logger.debug("SessionID\u65e0\u6548");
                return rtnresult;
            }
            rtnresult = new WebAuthResult();
            byte loginType = new Integer(loginInfo.getUsertype()).byteValue();
            rtnresult.setAccountType(loginType);
            rtnresult.setDigitAccount(String.valueOf(loginInfo.getUsernewno()));
            rtnresult.setOldAccount(loginInfo.getUsername());
            rtnresult.setStateCode(stateCode);
            rtnresult.setUserId(String.valueOf(loginInfo.getUserno()));
            if (rtnresult.getAccountType() == 0) {
                if (rtnresult.getOldAccount().equals(userAccount)) return rtnresult;
                return null;
            }
            if (rtnresult.getDigitAccount().equals(userAccount)) return rtnresult;
            return null;
        }
        catch (Exception e) {
            logger.error("Auth using stateCode Exception: " + e);
            return rtnresult;
        }
    }

    public static boolean authUsingPassByUsername(String username, String userpass) {
        CheckPassProxy passProxy = new CheckPassProxy();
        int result = passProxy.getCheckPassRtn(username, (byte)-1, userpass).getResult();
        return result == 200;
    }

    public static boolean authUsingPassByUserid(String userid, String userpass) {
        CheckPassProxy passProxy = new CheckPassProxy();
        int result = passProxy.getCheckPassRtn(userid, (byte)2, userpass).getResult();
        return result == 200;
    }

    public static byte[] transformInputstream(InputStream input) throws Exception {
        byte[] byt = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int b = 0;
        b = input.read();
        while (b != -1) {
            baos.write(b);
            b = input.read();
        }
        byt = baos.toByteArray();
        return byt;
    }

    private static String userinfo_sec2String(Resp_getuserinfo_sec userinfo_sec) {
        String toString = "";
        if (userinfo_sec != null) {
            toString = "userid:" + userinfo_sec.getUserno() + ",mail_status:" + userinfo_sec.getMail_status() + ",mail:" + userinfo_sec.getMail() + ",answer1:" + userinfo_sec.getAnswer1() + ",answer2:" + userinfo_sec.getAnswer2() + ",answer3:" + userinfo_sec.getAnswer3();
        }
        return toString;
    }

    private static String nametype2nameMap2String(Map<Byte, String> nametype2nameMap) {
        StringBuilder toString = new StringBuilder("\n");
        if (nametype2nameMap != null) {
            for (Map.Entry<Byte, String> entry : nametype2nameMap.entrySet()) {
                Byte key = entry.getKey();
                String value = entry.getValue();
                toString.append("key = " + key + ",value = " + value + "\n");
            }
        }
        return toString.toString();
    }

    private static boolean isNotEmpty(String str) {
        if (str == null) {
            return false;
        }
        return !str.trim().isEmpty();
    }

    private static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        return str.trim().isEmpty();
    }

    public static VIPInfo getVIPInfoByUserId(String userId) {
        Map<Object, Object> resultMap = new HashMap();
        VIPInfo vipInfo = new VIPInfo();
        resultMap = VIPNumberUtil.getVIPInfoMap(userId);
        if (((String)resultMap.get("ret")).equals("0")) {
            vipInfo.setDaily(Integer.valueOf((String)resultMap.get("daily")));
            vipInfo.setExpireString((String)resultMap.get("expire"));
            vipInfo.setGrow(Integer.valueOf((String)resultMap.get("grow")));
            vipInfo.setIsAutoDeduct((String)resultMap.get("autodeduct"));
            vipInfo.setIsRemind((String)resultMap.get("remind"));
            vipInfo.setIsVIP((String)resultMap.get("isvip"));
            vipInfo.setIsYear((String)resultMap.get("isyear"));
            vipInfo.setLevel(Integer.valueOf((String)resultMap.get("level")));
            vipInfo.setPayId(Integer.valueOf((String)resultMap.get("payid")));
            vipInfo.setPayNameString((String)resultMap.get("payname"));
            vipInfo.setRetString((String)resultMap.get("ret"));
            vipInfo.setUservasString((String)resultMap.get("uservas"));
            vipInfo.setUserIdString((String)resultMap.get("userid"));
        } else {
            vipInfo.setRetString((String)resultMap.get("ret"));
        }
        return vipInfo;
    }

    public static VIPInfo getVIPInfoByUserName(String userName) {
        logger.info("UserName= " + userName);
        VIPInfo vipInfo = new VIPInfo();
        String userId = null;
        if (UserUtility.isUserExists(userName)) {
            userId = UserUtility.getUserIdByUserName(userName);
            logger.info("userName=" + userName + ",userId= " + userId);
            vipInfo = UserUtility.getVIPInfoByUserId(userId);
        } else {
            logger.error(userName);
        }
        return vipInfo;
    }

    public static Xlnumber getXlnumberInfoByUserName(String userName) {
        Xlnumber xlnumber = new Xlnumber();
        List<String> resultList = VIPNumberUtil.getXlnumberInfoList(userName);
        String ret = null;
        String xlgn_info = null;
        if (resultList == null) {
            xlnumber.setIsNumber("0");
            xlnumber.setRetsString("1");
        }
        String[] strings = resultList.get(0).split("&");
        ret = strings[0].split("=")[1];
        xlgn_info = strings[1].split("=")[1];
        if (ret.equals("0")) {
            xlnumber.setIsNumber("1");
            xlnumber.setRetsString(ret);
            xlnumber.setNumberString(xlgn_info);
            xlnumber.setOwnerString(resultList.get(1));
            xlnumber.setMonthRentString(resultList.get(2));
            xlnumber.setPayTypeString(resultList.get(3));
            xlnumber.setIsAutoPay(resultList.get(4));
            xlnumber.setIsActivate(resultList.get(5));
            xlnumber.setIsLock(resultList.get(6));
            xlnumber.setIsRegisterVIP1(resultList.get(7));
            xlnumber.setStartTime(Long.valueOf(resultList.get(8)));
            xlnumber.setEndTime(Long.valueOf(resultList.get(9)));
            xlnumber.setRemindString(resultList.get(10));
        } else {
            xlnumber.setIsNumber("0");
            xlnumber.setRetsString(ret);
        }
        return xlnumber;
    }

    public static Xlnumber getXlnumberInfoByUserId(String userId) {
        String userName = UserUtility.getUserNameByUserId(userId);
        return UserUtility.getXlnumberInfoByUserName(userName);
    }

    static {
        userInfoProxy = ProxyFactory.getInstance().getUserInfoProxy();
        loginProxy = ProxyFactory.getInstance().getLoginProxy();
        vipProxy = ProxyFactory.getInstance().getVipProxy();
        UserUtility.initateWebAuthConfig();
        pnumber = Pattern.compile("\\d+");
        format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }
}

