/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.util;

import com.xunlei.channel.server.client.MemcachedFactory;
import com.xunlei.memcached.cached.client.MemCachedClient;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatClient {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    private static final Log logger = LogFactory.getLog(StatClient.class);
    private static MemCachedClient client = MemcachedFactory.getClientInstance();

    private static String getStatKey(String statType, String ... keyItems) {
        StringBuffer keysb = new StringBuffer();
        keysb.append(statType).append("-");
        Date date = new Date();
        String now = sdf.format(date);
        Calendar c = Calendar.getInstance();
        int hour = c.get(11);
        keysb.append(now).append("-").append(hour);
        for (String str : keyItems) {
            keysb.append("-").append(str);
        }
        logger.info(" StatKey is :" + keysb.toString());
        return keysb.toString();
    }

    public static void main(String[] args) {
        StatClient.statRunTime(1L, "TEST", "TEST", "00");
        System.out.println(client.get("T-20090422-20-TEST-TEST-00"));
    }

    public static void statRunCount(String ... keyItems) {
        String countKey = StatClient.getStatKey("C", keyItems);
        String countsize = "";
        countsize = (String)client.get(countKey);
        if (countsize == null || "".equals(countsize)) {
            client.set(countKey, "1");
        } else {
            int count = Integer.parseInt(countsize) + 1;
            String value = count + "";
            client.set(countKey, value);
        }
    }

    public static void statRunTime(long tradeTime, String ... keyItems) {
        String timeKey = StatClient.getStatKey("T", keyItems);
        String timesum = (String)client.get(timeKey);
        if (timesum == null) {
            client.set(timeKey, String.valueOf(tradeTime));
        } else {
            String time = Long.parseLong(timesum) + tradeTime + "";
            client.set(timeKey, time);
        }
    }

    public static void statCountAndTime(long tradeTime, String ... keyItems) {
        StatClient.statRunTime(tradeTime, keyItems);
        StatClient.statRunCount(keyItems);
    }
}

