/*
 * Decompiled with CFR 0.152.
 */
package com.ferret.common.dao;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.presql.CountSelect;
import com.ferret.common.dao.presql.Delete;
import com.ferret.common.dao.presql.Insert;
import com.ferret.common.dao.presql.Select;
import com.ferret.common.dao.presql.Update;
import com.ferret.common.dao.util.DaoLog;
import com.ferret.common.dao.util.DaoUtil;
import com.ferret.common.dao.vo.Page;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class BaseDaoImpl
extends JdbcDaoSupport
implements BaseDao {
    @Override
    public <T> T findById(Class<T> clazz, Number id) {
        Select select = new Select(clazz, id);
        List<T> list = this.executeQuery(clazz, select.getPreSql(), select.getParamsList());
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public Map<String, Object> findForMap(String preSql, List<Object> paramList) {
        return this.getJdbcTemplate().queryForMap(preSql, paramList.toArray());
    }

    @Override
    public <T> T findById(Class<T> clazz, String id) {
        Select select = new Select(clazz, id);
        List<T> list = this.executeQuery(clazz, select.getPreSql(), select.getParamsList());
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public <T> List<T> findByObject(Class<T> clazz, Object entity, Page page) {
        Select select = new Select(entity, page);
        return this.executeQuery(clazz, select.getPreSql(), select.getParamsList());
    }

    @Override
    public <T> List<T> findBySql(Class<T> clazz, String preSql, List<Object> paramList) {
        return this.executeQuery(clazz, preSql, paramList);
    }

    @Override
    public <T> List<T> findBySql(Class<T> clazz, String preSql) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        return this.executeQuery(clazz, preSql, paramList);
    }

    @Override
    public int count(Object entity) {
        CountSelect countselect = new CountSelect(entity);
        Object[] args = countselect.getParamsList().toArray();
        return this.getJdbcTemplate().queryForInt(countselect.getPreSql(), args);
    }

    @Override
    public void updateById(Object updateEntity) {
        Update update = new Update(updateEntity);
        this.execute(update.getPreSql(), update.getParamsList());
    }

    @Override
    public void insert(Object entity) {
        Insert insert = new Insert(entity);
        this.execute(insert.getPreSql(), insert.getParamsList());
    }

    @Override
    public <T> void deleteById(Class<T> clazz, Number id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        Delete delete = new Delete(clazz, id);
        this.execute(delete.getPreSql(), delete.getParamsList());
    }

    @Override
    public <T> void deleteById(Class<T> clazz, String id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        if ("".equals(id)) {
            throw new RuntimeException("id is emtpy");
        }
        Delete delete = new Delete(clazz, id);
        this.execute(delete.getPreSql(), delete.getParamsList());
    }

    @Override
    public <T> List<T> executeQuery(final Class<T> clazz, String preSql, final List<Object> paramList) {
        DaoLog log = new DaoLog();
        final ArrayList list = new ArrayList();
        this.getJdbcTemplate().query(preSql, new PreparedStatementSetter(){

            @Override
            public void setValues(PreparedStatement ps) throws SQLException {
                int i = 0;
                while (i < paramList.size()) {
                    ps.setObject(i + 1, paramList.get(i));
                    ++i;
                }
            }
        }, new RowCallbackHandler(){

            @Override
            public void processRow(ResultSet rs) throws SQLException {
                DaoUtil.getRSObject(rs, clazz, list);
            }
        });
        log.println(preSql, paramList);
        return list;
    }

    @Override
    public void execute(String presql, final List<Object> paramList) {
        DaoLog log = new DaoLog();
        this.getJdbcTemplate().execute(presql, new PreparedStatementCallback(){

            @Override
            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                int i = 0;
                while (i < paramList.size()) {
                    ps.setObject(i + 1, paramList.get(i));
                    ++i;
                }
                return ps.execute();
            }
        });
        log.println(presql, paramList);
    }
}

