package com.xunlei.niux.bonuscenter.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 日志上报
 * @author Administrator
 *
 */
public class LogReportUtil {
	private static Logger logger = LoggerFactory.getLogger(LogReportUtil.class.getName());
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	/**
	 * 上报日志
	 * @param report 日志内容
	 */
	public static void report(LogReport report){
		if(report==null){
			return;
		}
		StringBuilder sb=new StringBuilder();
		sb.append(sdf.format(report.logTime)).append("\t")
		  .append(urlencode(report.gameId)).append("\t")
		  .append(urlencode(report.serverId)).append("\t")
		  .append(urlencode(report.actId)).append("\t")
		  .append(urlencode(report.logSrc)).append("\t")
		  .append(urlencode(report.userId)).append("\t")
		  .append(urlencode(report.operatorId)).append("\t")
		  .append(urlencode(report.subOperatorId)).append("\t")
		  .append(urlencode(report.productId)).append("\t")
		  .append(urlencode(report.bonusNum)).append("\t")
		  .append(urlencode(report.num1)).append("\t")
		  .append(urlencode(report.num2)).append("\t")
		  .append(urlencode(report.str1)).append("\t")
		  .append(urlencode(report.str2));
		logger.info(sb.toString());
	}
	/**
	 * 使用urlencode对{value}加密
	 * @param value
	 * @return
	 */
	public static String urlencode(String value){
		if(value==null){
			return "";
		}
		try {
			return URLEncoder.encode(value, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}
	public static String urlencode(Integer value){
		if(value==null){
			return "";
		}
		return String.valueOf(value);
	}
	/**
	 * 日志信息
	 * @author Administrator
	 *
	 */
	public static class LogReport{
		public Date logTime;//日志时间
		public String gameId;//游戏gameId
		public String serverId;//游戏serverid
		public String actId;//活动id
		public String logSrc;//日志来源
		public String userId;//迅雷uid
		public String operatorId;//操作id
		public String subOperatorId;//
		public String productId;//产品id
		public Integer bonusNum;//积分数
		public Integer num1;
		public Integer num2;
		public String str1;
		public String str2;
	}
}
