package com.xunlei.niux.bonuscenter.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.xunlei.json.JSONUtil;

public class BonusUtil {
	private static Logger logger = LoggerFactory.getLogger(BonusUtil.class.getName());
	
    private static String accountChangeUrl="http://websvr.niu.xunlei.com/queryUserInfo.gameUserInfo?";
    
    public static String convertCustomerIdToUserId(String gameId, String customerId) {
    	return getAfterChangeAccout(gameId, "200", customerId);
    }
    
	public static String getAfterChangeAccout(String gameId,String type,String beforeAccount){

        Map<String,String> params = new HashMap<String, String>();
        params.put("gameid",gameId);
        params.put("type",type);
        params.put("accounts",beforeAccount);

        String url = accountChangeUrl + SignUtil.getSignatureContent(params);

        String result = get(url);

        String afterResult = "";
		try {

	        JSONObject jsonObject = new JSONObject(result);
	        int status = jsonObject.getInt("statues");
	        if(status != 0){
	            return "";
	        }
	        
			afterResult = jsonObject.getString("result");
		} catch (JSONException e) {
			logger.error("", e);}

        return afterResult.substring(afterResult.indexOf("=") + 1);
    }
	
	public static String getRtnAndDataJsonObject(int rtn, int total, Object data)
	{
		Map object = new HashMap(2);
		object.put("rtn", Integer.valueOf(rtn));
		object.put("total", Integer.valueOf(total));
		object.put("data", data);
		return JSONUtil.fromObject(object);
	}
	
	private static String get(String url) {
		String result = null;
		HttpClient client = null;
		
		try {
			client = new DefaultHttpClient();
			HttpGet httpGet = new HttpGet(url);
			HttpResponse resp = client.execute(httpGet);
			
			HttpEntity entity = resp.getEntity();
			result = EntityUtils.toString(entity , "UTF-8").trim();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if(client != null) {
				client.getConnectionManager().shutdown();
			}
		}
		
		return result;
	}
}
