package com.xunlei.niux.bonuscenter.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.bonus.bo.BonusTransBo;
import com.xunlei.niux.data.bonus.dto.BonusTransDTO;
import com.xunlei.niux.data.bonus.exception.BonusErrorCode;
import com.xunlei.niux.data.bonus.exception.BonusRuntimeException;
import com.xunlei.niux.data.bonus.facade.FacadeFactory;
import com.xunlei.niux.data.bonus.vo.BonusTrans;
import com.xunlei.niux.data.vipgame.vo.Activity;
/**
 * 查询积分记录
 * @author Liangdong
 *
 */
@Service
public class BonusTransQueryCmd  extends DefaultCmd{
	private static Logger logger = LoggerFactory.getLogger(BonusTransQueryCmd.class.getName());

	@CmdMapper({"/queryWithTransTime.do"})
	public Object cmd1(final XLHttpRequest request,final XLHttpResponse response){
		try{
			return query(request,response);
		}catch(Exception e){
			logger.error("查询积分记录异常",e);
			RetData retData=new RetData();
			retData.setErrmsg("查询积分记录异常");
			return JsonObjectUtil.getRtnAndDataJsonObject(1,retData);
		}
	}
	
	
	public Object query(final XLHttpRequest request,final XLHttpResponse response){
		
		Map<String, Object> resMap = new HashMap<String, Object>();
		
		String userId=request.getParameter("userId","");
		if("".equals(userId)){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1009, "userId为空");
		}
		
		int pageNo = request.getParameterInteger("pageNo", 1);
		int pageSize = request.getParameterInteger("pageSize", 10);
		pageSize = pageSize <= 0 ? 10 : pageSize;
		Page page=new Page();
		page.setPageNo(pageNo);
		page.setPageSize(pageSize);
		page.addOrder("transTime", OrderType.DESC);
		
		String queryTime = request.getParameter("queryTime", "");
		
//		List<BonusTrans> btList = new ArrayList<BonusTrans>();
//		//所有
//		if("".equals(queryTime)){
//			BonusTrans bt = new BonusTrans();
//			bt.setUserId(userId);
//			btList = FacadeFactory.INSTANCE.getBonusTransBo().find(bt, page);
//		}
//		//最近一段时间
//		else{
//			String expr = queryTime.replace("_", " ");
//			btList = FacadeFactory.INSTANCE.getBonusTransBo().findDateSub(userId, expr, page);
//		}
//		
//		if (btList==null||btList.isEmpty()) {
//			resMap.put("count", 0);
//			return JsonObjectUtil.getRtnAndDataJsonObject(0, resMap);
//		}
//		resMap.put("count", btList.size());
//		
//		
//		Map<String,Activity> actNoMap= getJiFenShopActivityFromDB();
//		
//		List<?> pageDataslist= convertToResultList(btList,actNoMap);
//		resMap.put("pageDatas", pageDataslist);
		
		List<BonusTransDTO> btList = new ArrayList<BonusTransDTO>();
		int count = 0;
		String expr = null;
		boolean skipQueryTime = "".equals(queryTime);
		BonusTransBo bonusTransBo = FacadeFactory.INSTANCE.getBonusTransBo();
		if(skipQueryTime){
			// 查询所有
			count = bonusTransBo.countBonusRecords(userId);
		} else {
			// 查询指定时间段
			expr = queryTime.replace("_", " ");
			count = bonusTransBo.countBonusRecords(userId, expr);
		}
		
		if (count == 0) {
			resMap.put("count", 0);
			return JsonObjectUtil.getRtnAndDataJsonObject(0, resMap);
		}
		
		btList = bonusTransBo.getBonusRecords(userId, expr, page);
		resMap.put("count", count);
		List<?> pageDataslist = convertToResultList(btList);
		resMap.put("pageDatas", pageDataslist);
		
		return JsonObjectUtil.getRtnAndDataJsonObject(0, resMap);
	}
	
	
	/*private List<?> convertToResultList(final List<BonusTrans> resList,final Map<String,Activity> actNoMap) {
		List<Object> mapList = new ArrayList<Object>();
		for(BonusTrans bt : resList){
			Map<String, Object> mapData = new HashMap<String, Object>();
			mapData.put("transTime", bt.getTransTime());
			mapData.put("transNum", bt.getTransNum());
			mapData.put("transDirect", bt.getTransDirect());
//			mapData.put("seqId", bt.getSeqId());
//			mapData.put("userId", bt);
//			mapData.put("userName", bt);
//			mapData.put("transNo", bt);
//			mapData.put("remark", bt);
//			mapData.put("bizNo", bt);
//			mapData.put("transIp", bt);
//			mapData.put("balanceDate", bt);
//			mapData.put("actNo", bt);
//			mapData.put("gameId", bt);
			Activity a = actNoMap.get(bt.getActNo());
			if(a == null){
				continue;
			}
			String actName = a.getTitle();
			mapData.put("actName",
					(actName == null || actName.isEmpty()) ? "" : actName);
			
			mapList.add(mapData);
		}
		return mapList;
	}*/
	
	private List<?> convertToResultList(final List<BonusTransDTO> btList) {
		List<Object> mapList = new ArrayList<Object>();
		for(BonusTransDTO bt : btList){
			Map<String, Object> mapData = new HashMap<String, Object>();
			mapData.put("transTime", bt.getTransTime());
			mapData.put("transNum", bt.getTransNum());
			mapData.put("transDirect", bt.getTransDirect());
//			mapData.put("seqId", bt.getSeqId());
//			mapData.put("userId", bt);
//			mapData.put("userName", bt);
//			mapData.put("transNo", bt);
//			mapData.put("remark", bt);
//			mapData.put("bizNo", bt);
//			mapData.put("transIp", bt);
//			mapData.put("balanceDate", bt);
//			mapData.put("actNo", bt);
//			mapData.put("gameId", bt);
			mapData.put("actName", (StringUtils.isBlank(bt.getTitle())) ? "" : bt.getTitle());
			
			mapList.add(mapData);
		}
		return mapList;
	}
	

	private Map<String, Activity> getJiFenShopActivityFromDB(){
		Map<String, Activity> acmap = new HashMap<String, Activity>();
		for(Activity a: com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getActivityBo().getJiFenShopActivity(Activity.class)){
    		if(!acmap.containsKey(a.getActno().trim()))
    			acmap.put(a.getActno(), a);
    	}
		return acmap;
	}
	
	
	 public static class RetData{
			private String errmsg="";
			private int totalpage=0;
			private List<Map<String,String>> data=new ArrayList<Map<String,String>>();
			public String getErrmsg() {
				return errmsg;
			}
			public void setErrmsg(final String errmsg) {
				this.errmsg = errmsg;
			}
			public int getTotalpage() {
				return totalpage;
			}
			public void setTotalpage(final int totalpage) {
				this.totalpage = totalpage;
			}
			public List<Map<String, String>> getData() {
				return data;
			}
			public void setData(final List<Map<String, String>> data) {
				this.data = data;
			}
		}
}
