package com.xunlei.niux.bonuscenter.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.bonuscenter.cmd.BonusConsumeReturnCmd.Ret;
import com.xunlei.niux.data.bonus.facade.FacadeFactory;
import com.xunlei.niux.data.bonus.vo.UserBonus;
import com.xunlei.niux.data.bonus.vo.UserBonusSort;
@Service
public class BonusSortQueryCmd extends DefaultCmd{
	@CmdMapper({"/queryuserbonussort.do"})
	public Object queryUserBonusSort(XLHttpRequest request,XLHttpResponse response){
		setInnerContentType(request,response);
		String userId=request.getParameter("userId");
		Map<String,Object> resultMap=new HashMap<String,Object>();
		resultMap.put("userId", userId);
		if(userId==null||"".equals(userId)){
			return JsonObjectUtil.getDataJsonObject(resultMap);
		}
		UserBonusSort usb=FacadeFactory.INSTANCE.getUserBonusSortBo().findByUserId(userId);
		if(usb==null){
			return JsonObjectUtil.getDataJsonObject(resultMap);
		}
		resultMap.put("sortNum", usb.getSortNum());
		resultMap.put("lastSortNum", usb.getLastSortNum());
		return JsonObjectUtil.getDataJsonObject(resultMap);
	}
	@CmdMapper({"/querybonussort.do"})
	public Object queryBonusSort(XLHttpRequest request,XLHttpResponse response){
		String userId=request.getParameter("userId");
		if(userId==null||"".equals(userId)){
			return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret("13","参数错误"));
		}
		UserBonusSort usb=FacadeFactory.INSTANCE.getUserBonusSortBo().findByUserId(userId);
		if(usb==null){
			return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret("2001","未参与排名"));
		}
		int count=FacadeFactory.INSTANCE.getUserBonusSortBo().count(new UserBonusSort());
		int forntNum=usb.getSortNum()-1;
		int behindNum=count-usb.getSortNum();
		List<Map<String,Object>> forntList=new ArrayList<Map<String,Object>>();
		List<Map<String,Object>> behandList=new ArrayList<Map<String,Object>>();
		for(int i=4;i>0;i--){
			if(usb.getSortNum()-i<=0){
				continue;
			}
			Map<String,Object> ub=getUserBonus(usb.getSortNum()-i);
			if(ub!=null){
				forntList.add(ub);
			}
		}
		for(int i=1;i<=4;i++){
			if(usb.getSortNum()+i>count){
				continue;
			}
			Map<String,Object> ub=getUserBonus(usb.getSortNum()+i);
			if(ub!=null){
				behandList.add(ub);
			}
		}
		Map<String,Object> resultMap=new HashMap<String,Object>();
		resultMap.put("forntNum", forntNum);
		resultMap.put("behindNum", behindNum);
		resultMap.put("forntPerson", forntList);
		resultMap.put("behindPerson", behandList);
		resultMap.put("code", "00");
		return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
	}
	private Map<String,Object> getUserBonus(int sortNum){
		UserBonusSort ubs=FacadeFactory.INSTANCE.getUserBonusSortBo().findByUserId(sortNum);
		if(ubs==null){
			return null;
		}
		UserBonus ub=FacadeFactory.INSTANCE.getUserBonusBo().find(ubs.getUserId());
		if(ub==null){
			return null;
		}
		Map<String,Object> map=new HashMap<String,Object>();
		map.put("name", ub.getUserName());
		map.put("bonus", ub.getRechargeSum());
		return map;
	}
}
