package com.xunlei.niux.bonuscenter.cmd;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.bonuscenter.cache.BonusLevelCacheManager;
import com.xunlei.niux.bonuscenter.cache.BonusLevelCacheManager.BonusLevelCache;
import com.xunlei.niux.bonuscenter.util.BonusUtil;
import com.xunlei.niux.data.bonus.exception.BonusErrorCode;
import com.xunlei.niux.data.bonus.exception.BonusRuntimeException;
import com.xunlei.niux.data.bonus.facade.FacadeFactory;
import com.xunlei.niux.data.bonus.vo.UserBonus;
/**
 * 查询积分
 * @author Administrator
 *
 */
@Service
public class BonusQueryCmd  extends DefaultCmd{
	private static Logger logger = LoggerFactory
			.getLogger(BonusQueryCmd.class.getName());
	/**
	 * 查询积分
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/querybonus.do"})
	public Object query(XLHttpRequest request,XLHttpResponse response){
		setInnerContentType(request,response);
		try{
			String userId = request.getParameter("userId","");
			
			// update 2016/01/21 添加参数customerId和gameId
			boolean userIdParam = true;	// true: 使用请求参数中的userId，false：使用customerId和gameId转换后的userId
			if("".equals(userId)) {
				userIdParam = false;
				String customerId = request.getParameter("customerId", "");
				String gameId = request.getParameter("gameId", "");
				userId = BonusUtil.convertCustomerIdToUserId(gameId, customerId);
				if(StringUtils.isBlank(userId)) {
					logger.error("Fail to find userId: gameId={}, customerId={}", gameId, customerId);
					return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret(BonusErrorCode.BONUS_CODE_1009, "账号不存在"));
				}
			}
			
			UserBonus userBonus=FacadeFactory.INSTANCE.getUserBonusBo().find(userId);
			if(userBonus==null){
				userBonus=new UserBonus();
				userBonus.setConsumeSum(0l);
				userBonus.setBonusNum(0);
				userBonus.setRechargeSum(0L);
				userBonus.setBonusLevel(0);
			}
			Map<String,Object> result=new HashMap<String,Object>();
			
			if(userIdParam) {
				// 内部调用时才返回userId
				result.put("userId", userBonus.getUserId()==null?userId:userBonus.getUserId());
				result.put("userName", userBonus.getUserName()==null?"":userBonus.getUserName());
			}
			
			result.put("rechargeSum", userBonus.getRechargeSum()==null?0:userBonus.getRechargeSum());
			result.put("consumeSum", userBonus.getConsumeSum()==null?0:userBonus.getConsumeSum());
			result.put("bonusNum", userBonus.getBonusNum()==null?0:userBonus.getBonusNum());
			result.put("bonusLevel", userBonus.getBonusLevel()==null?0:userBonus.getBonusLevel());
			result.put("bonusStatus", userBonus.getBonusStatus()==null?0:userBonus.getBonusStatus());
			result.put("lastRechargeTime", userBonus.getLastRechargeTime()==null?"":userBonus.getLastRechargeTime());
			result.put("lastConsumeTime", userBonus.getLastConsumeTime()==null?"":userBonus.getLastConsumeTime());
			result.put("remark", userBonus.getRemark()==null?"":userBonus.getRemark());
			result.put("bonusRanking", 0);
			/*
			 * 积分等级信息
			 */
			int curLevel=userBonus.getBonusLevel()==null?0:userBonus.getBonusLevel();
			BonusLevelCache levelCache=BonusLevelCacheManager.getInstance().getBonusLevelCache(curLevel);
			if(levelCache==null){
				levelCache=new BonusLevelCache();
			}
			result.put("levelUrl", levelCache.getLevelUrl()==null?"":levelCache.getLevelUrl());
			result.put("levelName", levelCache.getLevelName()==null?"":levelCache.getLevelName());
			/*
			 * 升级需要积分
			 */
			int nextLevel=curLevel+1;
			levelCache=BonusLevelCacheManager.getInstance().getBonusLevelCache(nextLevel);
			long nextLevelNeedNum=0;
			if(levelCache!=null){
				nextLevelNeedNum=levelCache.getMinBonusNum()-userBonus.getRechargeSum();
			}
			nextLevelNeedNum=nextLevelNeedNum<0?0:nextLevelNeedNum;
			result.put("nextLevelNeedNum", nextLevelNeedNum);
			return JsonObjectUtil.getRtnAndDataJsonObject(0,
					new Ret("00",result));
		}catch(BonusRuntimeException e){
			logger.error(e.getErrrorCode(), e);
			return JsonObjectUtil.getRtnAndDataJsonObject(0,
					new Ret(e.getErrrorCode(), e.getMessage()));
		}catch(Exception e){
			logger.error("出现异常", e);
			return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret("99",
					"未知错误"));
		}
	}
	
	public static class Ret{
		private String code;
		private String msg;
		private Map<String,Object> userBonus;
		public Ret(String code,String msg){
			this.code=code;
			this.msg=msg;
		}
		public Ret(String code,Map<String,Object> userBonus){
			this.code=code;
			this.userBonus=userBonus;
		}
		public String getCode() {
			return code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getMsg() {
			return msg;
		}
		public void setMsg(String msg) {
			this.msg = msg;
		}
		public Map<String,Object> getUserBonus() {
			return userBonus;
		}
		public void setUserBonus(Map<String,Object> userBonus) {
			this.userBonus = userBonus;
		}
	}
}
