package com.xunlei.niux.bonuscenter.cmd;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;


import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.bonuscenter.cache.BizInfoCacheManager;
import com.xunlei.niux.bonuscenter.cache.BizInfoCacheManager.BizInfoCache;
import com.xunlei.niux.bonuscenter.cache.LotteryInfoCacheManager;
import com.xunlei.niux.bonuscenter.util.BonusTransReportUtil;
import com.xunlei.niux.bonuscenter.util.BonusUtil;
import com.xunlei.niux.bonuscenter.util.IpUtil;
import com.xunlei.niux.bonuscenter.util.SignUtil;
import com.xunlei.niux.data.bonus.constant.BonusConstant;
import com.xunlei.niux.data.bonus.dto.LotteryBonusDataDTO;
import com.xunlei.niux.data.bonus.exception.BonusErrorCode;
import com.xunlei.niux.data.bonus.exception.BonusRuntimeException;
import com.xunlei.niux.data.bonus.facade.FacadeFactory;
import com.xunlei.niux.data.bonus.vo.BonusTrans;
import com.xunlei.niux.data.bonus.vo.LotteryInfo;
import com.xunlei.niux.data.bonus.vo.LotteryRecord;

/**
 * 积分博弈
 * @author Administrator
 *
 */
@Service
public class BonusLotteryCmd  extends DefaultCmd{
	
	private static Logger logger = LoggerFactory
			.getLogger(BonusLotteryCmd.class.getName());
	private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private static final SimpleDateFormat sdf_day = new SimpleDateFormat("yyyy-MM-dd");
	private static final String key = "sfh2359sfq12epda12";

	/**
	 * 积分博弈配置查询
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/queryLotteryBonusInfo.do"})
	public Object queryLotteryBonusInfo(XLHttpRequest request, XLHttpResponse response){
		this.setInnerContentType(request, response);

		//验证参数
		String bonus = request.getParameter("bonus");
		
		try {
			
			//验证签名
			String bizNo=request.getParameter("bizNo");
			String time=request.getParameter("time");
			String clientIp=IpUtil.getClientIp(request);

			//验证参数
			if(StringUtils.isEmpty(bizNo) || StringUtils.isEmpty(time)){
				logger.error("参数为空 bonus:"+bonus+",bizNo:"+bizNo+",time:"+time);
				return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret(BonusErrorCode.BONUS_CODE_1003, "参数为空"));
			}
			
			//验证超时
			long nowTimeStamp = System.currentTimeMillis()/1000;
			long myTimeStamp = Long.parseLong(time);
			if(Math.abs(nowTimeStamp - myTimeStamp) > 60*15  && myTimeStamp != 0){//前后15分钟失效
				logger.error("超时 bonus:"+bonus+",bizNo:"+bizNo+",time:"+time);
				return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret(BonusErrorCode.BONUS_CODE_1005, "超时"));
			}
			
			//修改，抛异常方式太慢
			BizInfoCache bizInfoCache = BizInfoCacheManager.getInstance().getAndcheckBizInfoValid(bizNo, clientIp);
			if(bizInfoCache == null){
				logger.error(BonusErrorCode.BONUS_CODE_1010, "业务["+bizNo+"]不存在");
				return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret(BonusErrorCode.BONUS_CODE_1010, "业务["+bizNo+"]不存在"));
			}
			
			checkSign(request, bizInfoCache);

			//缓存。查询博弈配置
			List<LotteryInfo> list = LotteryInfoCacheManager.getInstance().getLotteryInfosCache(bonus);
			
			if(list == null){
				list = new ArrayList<LotteryInfo>();
			}
			
			List<Map<String,Object>> result = new ArrayList<Map<String, Object>>();
			Map<String,Object> tempMap = new HashMap<String,Object>();
			for(LotteryInfo lotteryinfo : list){
				tempMap = new HashMap<String,Object>();
				tempMap.put("bonus", lotteryinfo.getBonus());
				tempMap.put("succsessRate", lotteryinfo.getSuccsessRate());
				tempMap.put("succsessBonus", lotteryinfo.getSuccsessBonus());
				tempMap.put("tieRate", lotteryinfo.getTieRate());
				tempMap.put("tieBonus", lotteryinfo.getTieBonus());
				tempMap.put("failRate", lotteryinfo.getFailRate());
				tempMap.put("failBonus", lotteryinfo.getFailBonus());
				result.add(tempMap);
			}
			
			return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
		} catch (BonusRuntimeException e) {
			logger.error(e.getErrrorCode(), e);
			return JsonObjectUtil.getRtnAndDataJsonObject(0,
					new Ret(e.getErrrorCode(), e.getMessage()));
		} catch (Exception e) {
			logger.error("出现异常", e);
			return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret("99",
					"未知错误"));
		}
	}
	
	/**
	 * 通过订单号查询博弈信息
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/queryLotteryBonusOrder.do"})
	public Object queryLotteryBonusOrder(XLHttpRequest request, XLHttpResponse response){
		this.setInnerContentType(request, response);

		//验证参数
		String orderId = request.getParameter("orderId");
		String bizNo=request.getParameter("bizNo");
		if(StringUtils.isEmpty(orderId) || StringUtils.isEmpty(bizNo)){
			return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret("1",
					"参数不全"));
		}
		try {
			String clientIp=IpUtil.getClientIp(request);
			//修改，抛异常方式太慢
			BizInfoCache bizInfoCache = BizInfoCacheManager.getInstance().getAndcheckBizInfoValid(bizNo, clientIp);
			if(bizInfoCache == null){
				logger.error(BonusErrorCode.BONUS_CODE_1010, "业务["+bizNo+"]不存在");
				return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret(BonusErrorCode.BONUS_CODE_1010, "业务["+bizNo+"]不存在"));
			}
			
			checkSignOrderId(request, bizInfoCache);
			
			LotteryRecord record = FacadeFactory.INSTANCE.getLotteryRecordBo().findByOrderId(orderId);
			Map<String,Object> tempMap = new HashMap<String,Object>();
			if(record != null){
				tempMap.put("orderId", record.getOrderId());
				tempMap.put("custormerId", record.getCustomerId());
				tempMap.put("gameId", record.getGameId());
				tempMap.put("serverId", record.getServerId());
				tempMap.put("bonus", record.getBonus());
				tempMap.put("status", record.getStatus());
				tempMap.put("time", record.getTime());
			}
			return JsonObjectUtil.getRtnAndDataJsonObject(0, tempMap);
			
		} catch (BonusRuntimeException e) {
			logger.error(e.getErrrorCode(), e);
			return JsonObjectUtil.getRtnAndDataJsonObject(0,
					new Ret(e.getErrrorCode(), e.getMessage()));
		} catch (Exception e) {
			logger.error("出现异常", e);
			return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret("99",
					"未知错误"));
		}
	}
	
	

	/**
	 * 积分博弈
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/lotteryBonus.do"})
	public Object lotteryBonus(XLHttpRequest request, XLHttpResponse response){
		this.setInnerContentType(request, response);
		try {
			String bonus=request.getParameter("bonus");
			int bonusInt = -1;
			try{
				bonusInt=Integer.parseInt(bonus);
			}catch(Exception e){
				logger.error("出现异常", e);
				return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret(BonusErrorCode.BONUS_CODE_1003, "参数错误"));
			}
			
			String bizNo=request.getParameter("bizNo","");
			String gameId=request.getParameter("gameId","");
			String serverId=request.getParameter("serverId","");
			String actNo=request.getParameter("actNo","");
			String advNo=request.getParameter("advNo","");
			String status=request.getParameter("status","");
			String orderId=request.getParameter("orderId","");
			String userId=request.getParameter("userId","");
			String customerId=request.getParameter("customerId","");
			String time=request.getParameter("time","");
			
			//验证参数
			if(StringUtils.isEmpty(bonus) || StringUtils.isEmpty(bizNo) 
					|| StringUtils.isEmpty(actNo) || StringUtils.isEmpty(time) 
					|| (StringUtils.isEmpty(userId) && (StringUtils.isEmpty(gameId) || StringUtils.isEmpty(customerId)) )){
				logger.error("参数为空 bonus:"+bonus+",bizNo:"+bizNo+",actNo:"+",time:"+time+",userId："+userId+",gameId:"+gameId + ",customerId:"+customerId);
				return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret(BonusErrorCode.BONUS_CODE_1003, "参数为空"));
			}
			
			//验证超时
			long nowTimeStamp = System.currentTimeMillis()/1000;
			long myTimeStamp = Long.parseLong(time);
			if(Math.abs(nowTimeStamp - myTimeStamp) > 60*15  && myTimeStamp != 0){//前后15分钟失效
				logger.error("超时 bonus:"+bonus+",bizNo:"+bizNo+",actNo:"+",time:"+time+",userId："+userId+",gameId:"+gameId + ",customerId:"+customerId);
				return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret(BonusErrorCode.BONUS_CODE_1005, "超时"));
			}

			if(StringUtils.isEmpty(userId) && customerId != null && !customerId.trim().equals("")){
				userId = BonusUtil.getAfterChangeAccout(gameId, "200", customerId);//200:加密账号转为uid
			}

			if(userId == null || userId.trim().equals("")){
				logger.error("账号不存在 userId："+userId + ",customerId:"+customerId);
				return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret(BonusErrorCode.BONUS_CODE_1004, "账号不存在"));
			}
			
			String clientIp=IpUtil.getClientIp(request);
			
			//修改，抛异常方式太慢
			BizInfoCache bizInfoCache = BizInfoCacheManager.getInstance().getAndcheckBizInfoValid(bizNo, clientIp);
			if(bizInfoCache == null){
				logger.error(BonusErrorCode.BONUS_CODE_1010, "业务["+bizNo+"]不存在");
				return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret(BonusErrorCode.BONUS_CODE_1010, "业务["+bizNo+"]不存在"));
			}
			checkSignLottery(request, bizInfoCache);

			//能否博弈
			LotteryInfo lotteryInfo = LotteryInfoCacheManager.getInstance().getLotteryInfoCache(bonusInt);
			if(lotteryInfo == null){
				logger.error(BonusErrorCode.BONUS_CODE_1050, "博弈失败：积分数量不正确。业务["+bizNo+"],积分数量:["+bonusInt+"]不正确");
				return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret(BonusErrorCode.BONUS_CODE_1050, "博弈失败：积分数量不正确。业务["+bizNo+"],积分数量:["+bonusInt+"]不正确"));
			
			}
			
			//验证订单耗时否重复
			LotteryRecord lotteryRecord = FacadeFactory.INSTANCE.getLotteryRecordBo().findByOrderId(orderId);
			if(lotteryRecord != null){
				logger.error("参数为空 bonus:"+bonus+",bizNo:"+bizNo+",actNo:"+",time:"+time+",userId："+userId+",gameId:"+gameId + ",customerId:"+customerId+",orderId："+orderId);
				return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret(BonusErrorCode.BONUS_CODE_1051, "订单重复"));
			}

			BonusTrans bonusTrans = initBonusTrans(request);
			
			//1.扣除积分
			FacadeFactory.INSTANCE.getBonusTransBo().insert(bonusTrans);
			
			//2.抽奖博弈
			LotteryRecord record = new LotteryRecord();
			record.setUserId(userId);
			record.setActNo(actNo);
			record.setAdvNo(advNo);
			record.setStatus(status);
			record.setBonus(bonusInt);
			record.setBizNo(bizNo);
			record.setGameId(gameId);
			record.setServerId(serverId);
			record.setCustomerId(customerId);
			record.setTime(sdf.format(new Date()));
			record.setOrderId(orderId);
			doLottery(record, lotteryInfo);
			
			//4.上报
			BonusTransReportUtil.report(bonusTrans, "2");
			return JsonObjectUtil.getRtnAndDataJsonObject(0,
					new Ret("00", "成功"));
		} catch (BonusRuntimeException e) {
			logger.error(e.getErrrorCode(), e);
			return JsonObjectUtil.getRtnAndDataJsonObject(0,
					new Ret(e.getErrrorCode(), e.getMessage()));
		} catch (Exception e) {
			logger.error("出现异常", e);
			return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret("99",
					"未知错误"));
		}
	}
	
	/**
	 * 初始化数据
	 * 
	 * @param request
	 * @return
	 */
	private static BonusTrans initBonusTrans(final XLHttpRequest request) {
		BonusTrans bonusTrans = new BonusTrans();
		bonusTrans.setBizNo(request.getParameter("bizNo", ""));
		bonusTrans.setRemark(request.getParameter("remark", ""));
		bonusTrans.setTransNo(""+System.currentTimeMillis() +(int)(Math.random()*10));
		bonusTrans.setTransNum(request.getParameterInteger("bonus"));
		
		String userId = request.getParameter("userId", "");
		
		// update 2016/01/22 添加参数customerId和gameId
		if("".equals(userId)) {
			String customerId = request.getParameter("customerId");
			String gameId = request.getParameter("gameId");
			userId = BonusUtil.convertCustomerIdToUserId(gameId, customerId);
			if(StringUtils.isBlank(userId)) {
				logger.error("Fail to find userId: gameId={}, customerId={}", gameId, customerId);
				throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1009, "账号不存在");
			}
		}
		
		bonusTrans.setUserId(userId);
		bonusTrans.setUserName(request.getParameter("userName", ""));
		bonusTrans.setBalanceDate(sdf_day.format(new Date()));
		bonusTrans.setGameId(request.getParameter("gameId",""));
		bonusTrans.setActNo(request.getParameter("actNo",""));
		bonusTrans.setTransDirect(BonusConstant.BONUS_TRANSDIRECT_CONSUME);
		bonusTrans.setTransIp(IpUtil.getClientIp(request));
		return bonusTrans;
	}
	

	/**
	 * 初始化博弈奖品发放参数数据
	 * 
	 * @param request
	 * @return
	 */
	private static BonusTrans initLotteryBonusTrans(final LotteryRecord record) {
		BonusTrans bonusTrans = new BonusTrans();
		bonusTrans.setBizNo(record.getBizNo());
		bonusTrans.setRemark("[system]release product.OrderId:"+record.getOrderId());
		bonusTrans.setTransNo(""+System.currentTimeMillis() +(int)(Math.random()*10));
		
		int transNum = Math.abs(record.getOutcomeBonus());
		bonusTrans.setTransNum(transNum);
		
		bonusTrans.setUserId(record.getUserId());
		bonusTrans.setUserName(record.getUserId());
		bonusTrans.setBalanceDate(sdf_day.format(new Date()));
		bonusTrans.setGameId(record.getGameId());
		bonusTrans.setActNo(record.getActNo());
		bonusTrans.setTransDirect("1".equals(record.getStatus()) ? BonusConstant.BONUS_TRANSDIRECT_CONSUME : BonusConstant.BONUS_TRANSDIRECT_RECHARGE);
		bonusTrans.setTransIp("127.0.0.1");
		return bonusTrans;
	}

	/**
	 * 发放代金券和或现金券
	 * @param record
	 * @param lotteryInfo
	 */
	private synchronized void doLottery(LotteryRecord record, LotteryInfo lotteryInfo){

		LotteryRecord hisRecord = null;
		try{
			//成功
			if("0".equals(record.getStatus())){
				record.setOutcomeBonus(Integer.parseInt(lotteryInfo.getSuccsessBonus()));
			}else if("2".equals(record.getStatus())){//平局
				record.setOutcomeBonus(Integer.parseInt(lotteryInfo.getTieBonus()));
			}else{//失败
				record.setStatus("1");//失败
				record.setOutcomeBonus(Integer.parseInt(lotteryInfo.getFailBonus()));
			}
			
			//查询看数据库有没有记录，有记录说明之前可能发放失败，也可能别的线程发放成功了
			if(record.getSeqId() != null){
				hisRecord = FacadeFactory.INSTANCE.getLotteryRecordBo().find(record.getSeqId());
			}

			//中奖处理积分的发放与扣除
			boolean hasSend = false;
			if(hisRecord != null && hisRecord.getOutcomeBonus() != null){
				hasSend = true;
				record.setOutcomeBonus(hisRecord.getOutcomeBonus());
			}
			
			//没发过才发
			if(!hasSend){
				BonusTrans bonusTrans = initLotteryBonusTrans(record);
				int outcomeBonus = record.getOutcomeBonus();
				record.setOutcomeBonus(null);
				FacadeFactory.INSTANCE.getBonusTransBo().insert(bonusTrans);
				record.setOutcomeBonus(outcomeBonus);
			}
			
		}catch(Exception e){
			logger.error("", e);
		}finally{
			if(hisRecord == null){
				//3.插入抽奖博弈记录
				FacadeFactory.INSTANCE.getLotteryRecordBo().insert(record);
			}else{
				//3.批次号发放成功，就更新
				FacadeFactory.INSTANCE.getLotteryRecordBo().update(record);
			}
		}
		
	}
	
	/**
	 * 积分博弈记录查询
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/checkExistLotteryBonusRecord.do"})
	public Object checkExistLotteryRecord(XLHttpRequest request, XLHttpResponse response){
		this.setInnerContentType(request, response);
		int count = 0;
		try {
			this.setInnerContentType(request, response);
			String userId=request.getParameter("userId");
			String gameId=request.getParameter("gameId");
			String serverId=request.getParameter("serverId");
			String actNo=request.getParameter("actNo");
			String advNo=request.getParameter("advNo");
			String status=request.getParameter("status");
			String beginTime=request.getParameter("beginTime");
			String endTime=request.getParameter("endTime");
			int pageNo=request.getParameterInteger("pageNo",0);//页码，默认查询所有
			int pageSize=request.getParameterInteger("pageSize",0);//每页行数，默认查询所有
			
			if(userId== null || "".equals(userId)){
				return JsonObjectUtil.getRtnAndDataJsonObject(3, "userId为空");
			}
			
			String bonus = request.getParameter("bonus");
			Integer bonusInt = null;
			try{
				if(!StringUtils.isEmpty(bonus)){
					bonusInt=Integer.parseInt(bonus);
				}
			}catch(Exception e){
				logger.error("出现异常", e);
				return JsonObjectUtil.getRtnAndDataJsonObject(4, "参数错误");
			}
			
			//验证签名
//			String clientIp=IpUtil.getClientIp(request);
			String bizNo=request.getParameter("bizNo");
//			//修改，抛异常方式太慢
//			Ret ret = new Ret("00", "成功");
//			BizInfoCache bizInfoCache = BizInfoCacheManager.getInstance().getAndcheckBizInfoValid(bizNo, clientIp, ret);
//			if(bizInfoCache == null){
//				logger.error(ret.getCode(), ret.getMsg(), ret.getUserBonus());
//				return JsonObjectUtil.getRtnAndDataJsonObject(0, ret);
//			}
			checkSignExistLottery(request);
			
			//查询博弈配置
			Page page = new Page();
			page.setPageNo(pageNo);
			page.setPageSize(pageSize);
			page.addOrder("time", OrderType.DESC);
			
			LotteryRecord record = new LotteryRecord();
			if(!StringUtils.isEmpty(userId))
				record.setUserId(userId);
			
			if(!StringUtils.isEmpty(actNo))
				record.setActNo(actNo);
			
			if(!StringUtils.isEmpty(advNo))
				record.setAdvNo(advNo);
			
			if(!StringUtils.isEmpty(status))
				record.setStatus(status);
			
			if(!StringUtils.isEmpty(bonus))
				record.setBonus(bonusInt);
			
			if(!StringUtils.isEmpty(bizNo))
				record.setBizNo(bizNo);
			
			if(!StringUtils.isEmpty(gameId))
				record.setGameId(gameId);
			
			if(!StringUtils.isEmpty(serverId))
				record.setServerId(serverId);
			
			if(!StringUtils.isEmpty(beginTime))
				record.setBeginTime(beginTime);
			
			if(!StringUtils.isEmpty(endTime))
				record.setEndTime(endTime);
			
			count = FacadeFactory.INSTANCE.getLotteryRecordBo().count(record);
			
			if(count <= 0){
				return JsonObjectUtil.getRtnAndDataJsonObject(0, "查询成功，无充值订单");
			}

			return JsonObjectUtil.getRtnAndDataJsonObject(1, "查询成功，有充值订单");
		} catch (BonusRuntimeException e) {
			logger.error(e.getErrrorCode(), e);
			return JsonObjectUtil.getRtnAndDataJsonObject(99, e.getMessage());
		} catch (Exception e) {
			logger.error("出现异常", e);
			return JsonObjectUtil.getRtnAndDataJsonObject(99, "查询异常");
		}
	}
	

	/**
	 * 积分博弈记录查询
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/queryLotteryBonusRecord.do"})
	public Object queryLotteryBonusRecord(XLHttpRequest request, XLHttpResponse response){
		this.setInnerContentType(request, response);
		int count = 0;
		try {
			this.setInnerContentType(request, response);
	        MainParam mainParam = this.getMainParamSafe(request, response, true);
	        Long uid = mainParam.getUserid();
//	        Long uid = 123540516L;
	        
			String userId=uid.toString();
			String gameId=request.getParameter("gameId");
			String serverId=request.getParameter("serverId");
			String actNo=request.getParameter("actNo");
			String advNo=request.getParameter("advNo");
			String status=request.getParameter("status");
			String beginTime=request.getParameter("beginTime");
			String endTime=request.getParameter("endTime");
			int pageNo=request.getParameterInteger("pageNo",0);//页码，默认查询所有
			int pageSize=request.getParameterInteger("pageSize",0);//每页行数，默认查询所有
			
			if(userId== null || "".equals(userId)){
				throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1009, "userId为空");
			}
			
			String bonus = request.getParameter("bonus");
			Integer bonusInt = null;
			try{
				if(!StringUtils.isEmpty(bonus)){
					bonusInt=Integer.parseInt(bonus);
				}
			}catch(Exception e){
				logger.error("出现异常", e);
				return BonusUtil.getRtnAndDataJsonObject(0, count,  new Ret(BonusErrorCode.BONUS_CODE_1003, "参数错误"));
			}
			
			//验证签名
			String bizNo=request.getParameter("bizNo");
			
			//查询博弈配置
			Page page = new Page();
			page.setPageNo(pageNo);
			page.setPageSize(pageSize);
			page.addOrder("time", OrderType.DESC);
			
			LotteryRecord record = new LotteryRecord();
			if(!StringUtils.isEmpty(userId))
				record.setUserId(userId);
			
			if(!StringUtils.isEmpty(actNo))
				record.setActNo(actNo);
			
			if(!StringUtils.isEmpty(advNo))
				record.setAdvNo(advNo);
			
			if(!StringUtils.isEmpty(status))
				record.setStatus(status);
			
			if(!StringUtils.isEmpty(bonus))
				record.setBonus(bonusInt);
			
			if(!StringUtils.isEmpty(bizNo))
				record.setBizNo(bizNo);
			
			if(!StringUtils.isEmpty(gameId))
				record.setGameId(gameId);
			
			if(!StringUtils.isEmpty(serverId))
				record.setServerId(serverId);
			
			if(!StringUtils.isEmpty(beginTime))
				record.setBeginTime(beginTime);
			
			if(!StringUtils.isEmpty(endTime))
				record.setEndTime(endTime);
			
			count = FacadeFactory.INSTANCE.getLotteryRecordBo().count(record);
			
			List<Map<String,Object>> result = new ArrayList<Map<String, Object>>();
			if(count <= 0){
				return BonusUtil.getRtnAndDataJsonObject(0, count, result);
			}
			
			List<LotteryRecord> list = FacadeFactory.INSTANCE.getLotteryRecordBo().find(record, page);
			Map<String,Object> tempMap = new HashMap<String,Object>();
			for(LotteryRecord lotteryrecord : list){
				tempMap = new HashMap<String,Object>();
				tempMap.put("bizNo", lotteryrecord.getBizNo());
				tempMap.put("userId", lotteryrecord.getUserId());
				tempMap.put("gameId", lotteryrecord.getGameId());
				tempMap.put("serverId", lotteryrecord.getServerId());
				tempMap.put("customerId", lotteryrecord.getCustomerId());
				tempMap.put("actNo", lotteryrecord.getActNo());
				tempMap.put("advNo", lotteryrecord.getAdvNo());
				tempMap.put("bonus", lotteryrecord.getBonus());
				tempMap.put("status", lotteryrecord.getStatus());
				tempMap.put("outcomebonus", lotteryrecord.getOutcomeBonus());
				tempMap.put("time", lotteryrecord.getTime());
				result.add(tempMap);
			}

			return BonusUtil.getRtnAndDataJsonObject(0, count, result);
		} catch (BonusRuntimeException e) {
			logger.error(e.getErrrorCode(), e);
			return BonusUtil.getRtnAndDataJsonObject(0, count, 
					new Ret(e.getErrrorCode(), e.getMessage()));
		} catch (Exception e) {
			logger.error("出现异常", e);
			return BonusUtil.getRtnAndDataJsonObject(0, count, new Ret("99",
					"未知错误"));
		}
	}
	
	/**
	 * 积分博弈统计查询
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/queryLotteryBonusData.do"})
	public Object queryLotteryBonusData(XLHttpRequest request, XLHttpResponse response){
		this.setInnerContentType(request, response);
		try {
			this.setInnerContentType(request, response);
	        MainParam mainParam = this.getMainParamSafe(request, response, true);
	        Long uid = mainParam.getUserid();
//	        Long uid = 256149977L;
	        
			String userId=uid.toString();
			String gameId=request.getParameter("gameId");
			String serverId=request.getParameter("serverId");
			String actNo=request.getParameter("actNo");
			String advNo=request.getParameter("advNo");
			String status=request.getParameter("status");
			String beginTime=request.getParameter("beginTime");
			String endTime=request.getParameter("endTime");
			
			if(userId== null || "".equals(userId)){
				throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1009, "userId为空");
			}
			
			String bonus = request.getParameter("bonus");
			Integer bonusInt = null;
			try{
				if(!StringUtils.isEmpty(bonus)){
					bonusInt=Integer.parseInt(bonus);
				}
			}catch(Exception e){
				logger.error("出现异常", e);
				return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret(BonusErrorCode.BONUS_CODE_1003, "参数错误"));
			}
			
			//验证签名
			String bizNo=request.getParameter("bizNo");
			
			//查询博弈配置
			LotteryRecord record = new LotteryRecord();
			if(!StringUtils.isEmpty(userId))
				record.setUserId(userId);
			
			if(!StringUtils.isEmpty(actNo))
				record.setActNo(actNo);
			
			if(!StringUtils.isEmpty(advNo))
				record.setAdvNo(advNo);
			
			if(!StringUtils.isEmpty(status))
				record.setStatus(status);
			
			if(!StringUtils.isEmpty(bonus))
				record.setBonus(bonusInt);
			
			if(!StringUtils.isEmpty(bizNo))
				record.setBizNo(bizNo);
			
			if(!StringUtils.isEmpty(gameId))
				record.setGameId(gameId);
			
			if(!StringUtils.isEmpty(serverId))
				record.setServerId(serverId);
			
			if(!StringUtils.isEmpty(beginTime))
				record.setBeginTime(beginTime);
			
			if(!StringUtils.isEmpty(endTime))
				record.setEndTime(endTime);
			
			List<LotteryBonusDataDTO> list = FacadeFactory.INSTANCE.getLotteryRecordBo().summary(record);
			
			if(list == null){
				logger.warn("queryLotteryBonusData 无数据");
				return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret(BonusErrorCode.BONUS_CODE_1006, "无数据"));
			}

			int bonusNum = 0;//消耗总积分
			int successNum = 0;//胜出产出积分总数
			int tieNum = 0;//平局产出积分总数
			int failNum = 0;//失败产出积分总数
			int successCount = 0;//胜出次数
			int tieCount = 0;//平局次数
			int failCount = 0;//失败次数
			
			for(LotteryBonusDataDTO lotteryrecord : list){
				int bonusConsume = lotteryrecord.getBonus() == null ? 0 : lotteryrecord.getBonus();
				int outcomeBonus = lotteryrecord.getOutcomeBonus() == null ? 0 : lotteryrecord.getOutcomeBonus();
				int count = lotteryrecord.getCount() == null ? 0 : lotteryrecord.getCount();
				
				bonusNum += bonusConsume;
				
				if("0".equals(lotteryrecord.getStatus())){//胜出
					successNum += outcomeBonus;
					successCount += count;
					
				}else if("1".equals(lotteryrecord.getStatus())){//失败
					failNum += outcomeBonus;
					failCount += count;
					
				}else if("2".equals(lotteryrecord.getStatus())){//平局
					tieNum += outcomeBonus;
					tieCount += count;
					
				}
				
			}
			
			Map<String,Object> tempMap = new HashMap<String,Object>();
			tempMap.put("bonusNum", bonusNum);
			tempMap.put("successNum", successNum);
			tempMap.put("tieNum", tieNum);
			tempMap.put("failNum", failNum);
			tempMap.put("successCount", successCount);
			tempMap.put("tieCount", tieCount);
			tempMap.put("failCount", failCount);
			
			return JsonObjectUtil.getRtnAndDataJsonObject(0, tempMap);
		} catch (BonusRuntimeException e) {
			logger.error(e.getErrrorCode(), e);
			return JsonObjectUtil.getRtnAndDataJsonObject(0,
					new Ret(e.getErrrorCode(), e.getMessage()));
		} catch (Exception e) {
			logger.error("出现异常", e);
			return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret("99",
					"未知错误"));
		}
	}

	/**
	 * 验证签名是否ok
	 * @param request
	 * @param bizInfo
	 */
	private static void checkSign(final XLHttpRequest request,final BizInfoCache bizInfoCache){
		Map<String,String> param=new HashMap<String,String>();
		param.put("bizNo", request.getParameter("bizNo",""));
		param.put("bonus", request.getParameter("bonus",""));
		param.put("time", request.getParameter("time", ""));
		String sign = SignUtil.sign(param, bizInfoCache.getBizPwd());
		String oldSign=request.getParameter("sign");
		if(!sign.equals(oldSign)){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1012, "参数中签名["+oldSign+"]不正确");
		}
	}
	
	/**
	 * 验证签名是否ok
	 * @param request
	 * @param bizInfo
	 */
	private static void checkSignOrderId(final XLHttpRequest request,final BizInfoCache bizInfoCache){
		Map<String,String> param=new HashMap<String,String>();
		param.put("orderId", request.getParameter("orderId",""));
		param.put("bizNo", request.getParameter("bizNo",""));
		param.put("time", request.getParameter("time", ""));
		String sign = SignUtil.sign(param, bizInfoCache.getBizPwd());
		String oldSign=request.getParameter("sign");
		if(!sign.equals(oldSign)){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1012, "参数中签名["+oldSign+"]不正确");
		}
	}


	/**
	 * 验证博弈签名是否ok
	 * @param request
	 * @param bizInfo
	 */
	private static void checkSignLottery(final XLHttpRequest request,final BizInfoCache bizInfoCache){
		Map<String,String> param=new HashMap<String,String>();
//		actNo=jfby&bizNo=00001&bonus=50&
//		customerId=xlnn00000000002&gameId=060003
//				&orderId=06000220160515133245222&status=0
//				&time= 1453711411<密钥>
		param.put("actNo", request.getParameter("actNo",""));
		param.put("bizNo", request.getParameter("bizNo",""));
		param.put("bonus", request.getParameter("bonus",""));
		param.put("customerId", request.getParameter("customerId",""));
		param.put("gameId", request.getParameter("gameId",""));
		param.put("orderId", request.getParameter("orderId", ""));
		param.put("status", request.getParameter("status",""));
		param.put("time", request.getParameter("time", ""));
		String sign = SignUtil.sign(param, bizInfoCache.getBizPwd());
		String oldSign = request.getParameter("sign");
		if(!sign.equals(oldSign)){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1012, "参数中签名["+oldSign+"]不正确");
		}
	}
	

	/**
	 * 验证是否讯在博弈记录接口签名是否ok
	 * @param request
	 * @param bizInfo
	 */
	private static void checkSignExistLottery(final XLHttpRequest request){
		Map<String,String> param=new HashMap<String,String>();
		param.put("userId", request.getParameter("userId", ""));
		String sign = SignUtil.sign(param, key);
		String oldSign=request.getParameter("sign");
		if(!sign.equals(oldSign)){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1012, "参数中签名["+oldSign+"]不正确");
		}
	}

}
