package com.xunlei.niux.bonuscenter.cmd;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.niux.bonuscenter.cache.BonusLevelCacheManager;
import com.xunlei.niux.bonuscenter.cmd.BizInfoCacheUpdateCmd.Ret;
import com.xunlei.niux.data.bonus.exception.BonusRuntimeException;

@Service
public class BonusLevelCacheUpdateCmd extends DefaultCmd {
	private static Logger logger = LoggerFactory
			.getLogger(BonusLevelCacheUpdateCmd.class.getName());
	/**
	 * 更新积分等级缓存
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/updatebonuslevelcache.do"})
	public Object updateBonusLevelCache(XLHttpRequest request,XLHttpRequest response){
		try {
			BonusLevelCacheManager.getInstance().updateCache();
			return JsonObjectUtil.getRtnAndDataJsonObject(0,
					new Ret("00", "成功"));
		} catch (BonusRuntimeException e) {
			logger.error(e.getErrrorCode(), e);
			return JsonObjectUtil.getRtnAndDataJsonObject(0,
					new Ret(e.getErrrorCode(), e.getMessage()));
		} catch (Exception e) {
			logger.error("出现异常", e);
			return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret("99",
					"未知错误"));
		}
	}
}
