package com.xunlei.niux.bonuscenter.cmd;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.bonuscenter.cache.BizInfoCacheManager;
import com.xunlei.niux.bonuscenter.cache.BizInfoCacheManager.BizInfoCache;
import com.xunlei.niux.bonuscenter.util.BonusTransReportUtil;
import com.xunlei.niux.bonuscenter.util.IpUtil;
import com.xunlei.niux.bonuscenter.util.SignUtil;
import com.xunlei.niux.data.bonus.constant.BonusConstant;
import com.xunlei.niux.data.bonus.exception.BonusErrorCode;
import com.xunlei.niux.data.bonus.exception.BonusRuntimeException;
import com.xunlei.niux.data.bonus.facade.FacadeFactory;
import com.xunlei.niux.data.bonus.vo.BonusTrans;

@Service
public class BonusConsumeReturnCmd extends DefaultCmd{
	private static Logger logger = LoggerFactory
			.getLogger(BonusRechargeCmd.class.getName());
	/**
	 * 退单
	 * @param reqeust
	 * @param response
	 * @return
	 */
	@CmdMapper({"/returnconsume.do"})
	public Object returnConsume(XLHttpRequest request,XLHttpResponse response){
		try{
			String bizNo=request.getParameter("bizNo");
			String clientIp=IpUtil.getClientIp(request);
			BizInfoCache bizInfoCache = BizInfoCacheManager.getInstance().getAndcheckBizInfoValid(bizNo, clientIp);
			checkSign(request,bizInfoCache);
			BonusTrans bonusTrans=initBonusTrans(request);
			//判断订单是否能退
			checkIsReturn(bonusTrans);
			FacadeFactory.INSTANCE.getBonusTransBo().insert(bonusTrans);
			BonusTransReportUtil.report(bonusTrans, "3");
			return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret("00","成功"));
		}catch(BonusRuntimeException e){
			logger.error(e.getErrrorCode(),e);
			return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret(e.getErrrorCode(),e.getMessage()));
		}catch(Exception e){
			logger.error("出现异常",e);
			return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret("99","未知错误"));
		}
	}
	public static class Ret{
		private String code;
		private String msg;
		public Ret(String code,String msg){
			this.code=code;
			this.msg=msg;
		}
		public String getCode() {
			return code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getMsg() {
			return msg;
		}
		public void setMsg(String msg) {
			this.msg = msg;
		}
		
	}
	private static BonusTrans initBonusTrans(final XLHttpRequest request){
		BonusTrans bonusTrans=new BonusTrans();
		bonusTrans.setBizNo(request.getParameter("bizNo",""));
		bonusTrans.setRemark(request.getParameter("remark",""));
		bonusTrans.setTransNo(request.getParameter("transNo",""));
		bonusTrans.setTransNum(request.getParameterInteger("transNum"));
		bonusTrans.setUserId(request.getParameter("userId",""));
		bonusTrans.setBalanceDate(request.getParameter("balanceDate",""));
		bonusTrans.setTransDirect(BonusConstant.BONUS_TRANSDIRECT_CONSUMERETURN);
		bonusTrans.setGameId(request.getParameter("gameId",""));
		bonusTrans.setActNo(request.getParameter("actNo",""));
		bonusTrans.setTransIp(IpUtil.getClientIp(request));
		return bonusTrans;
	}
	/**
	 * 验证签名是否ok
	 * @param request
	 * @param bizInfo
	 */
	private static void checkSign(final XLHttpRequest request,final BizInfoCache bizInfoCache){
		Map<String,String> param=new HashMap<String,String>();
		param.put("userId", request.getParameter("userId", ""));
		param.put("transNum", request.getParameter("transNum",""));
		param.put("transNo", request.getParameter("transNo",""));
		param.put("bizNo",  request.getParameter("bizNo",""));
		param.put("balanceDate", request.getParameter("balanceDate",""));
		param.put("gameId", request.getParameter("gameId",""));
		param.put("actNo", request.getParameter("actNo",""));
		String sign=SignUtil.sign(param, bizInfoCache.getBizPwd());
		String oldSign=request.getParameter("sign");
		if(!sign.equals(oldSign)){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1012, "新签名["+sign+"]与参数中签名["+oldSign+"]不一致");
		}
	}
	/**
	 * 验证是否能够退还积分
	 * @param bonusTrans
	 */
	private static void checkIsReturn(BonusTrans bonusTrans){
		//查询对应的消费交易
		BonusTrans consumeTrans=FacadeFactory.INSTANCE.getBonusTransBo().find(bonusTrans.getUserId(), bonusTrans.getBizNo(), bonusTrans.getTransNo(), BonusConstant.BONUS_TRANSDIRECT_CONSUME);
		if(consumeTrans==null){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1040,"消费订单["+bonusTrans.getTransNo()+"]不存在");
		}
		if(!bonusTrans.getTransNum().equals(consumeTrans.getTransNum())){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1041,"消费订单["+bonusTrans.getTransNo()+"]的消费积分["+consumeTrans.getTransNum()
					+"]与退还积分["+bonusTrans.getTransNum()+"]不一致"); 
		}
		bonusTrans.setUserName(consumeTrans.getUserName());
	}
}
