package com.xunlei.niux.bonuscenter.cmd;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.bonuscenter.cmd.BonusConsumeCmd.Ret;
import com.xunlei.niux.data.bonus.exception.BonusErrorCode;
import com.xunlei.niux.data.bonus.exception.BonusRuntimeException;
import com.xunlei.niux.data.bonus.facade.FacadeFactory;
import com.xunlei.niux.data.bonus.vo.UserBonus;

/**
 * 检查积分是否足够支付
 * @author Administrator
 *
 */
@Service
public class BonusCheckEnoughConsumeCmd extends DefaultCmd{
	private static Logger logger = LoggerFactory
			.getLogger(BonusCheckEnoughConsumeCmd.class.getName());
	/**
	 * 检查是否足够支付
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/checkenoughconsume.do"})
	public Object checkEnoughConsume(XLHttpRequest request,XLHttpResponse response){
		String userId=request.getParameter("userId");
		Integer bonusNum=request.getParameterInteger("bonusNum");
		try{
			UserBonus userBonus=FacadeFactory.INSTANCE.getUserBonusBo().find(userId);
			checkEnough(userBonus, bonusNum);
			return JsonObjectUtil.getRtnAndDataJsonObject(0,
					new Ret("00", "能支付"));
		} catch (BonusRuntimeException e) {
			return JsonObjectUtil.getRtnAndDataJsonObject(0,
					new Ret(e.getErrrorCode(), e.getMessage()));
		} catch (Exception e) {
			logger.error(userId+"查询积分是否能够支付出现异常"+e);
			return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret("99",
					"未知错误"));
		}
	}
	private void checkEnough(UserBonus userBonus,Integer bonusNum){
		if(userBonus==null){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1020,"积分不存在");
		}
		if(userBonus.getBonusStatus()>0){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1022,"用户["+userBonus.getUserId()+"]积分被冻结");
		}
		if(userBonus.getBonusNum()-bonusNum<0){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1021,"用户["+userBonus.getUserId()+"]积分不够");
		}
	}
}
