package com.xunlei.niux.bonuscenter.cmd;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.bonuscenter.cache.BonusLevelCacheManager;
import com.xunlei.niux.bonuscenter.cache.BonusLevelCacheManager.BonusLevelCache;
import com.xunlei.niux.data.bonus.exception.BonusErrorCode;
import com.xunlei.niux.data.bonus.exception.BonusRuntimeException;
import com.xunlei.niux.data.bonus.facade.FacadeFactory;
import com.xunlei.niux.data.bonus.vo.UserBonus;
/**
 * 查询当天获得的积分
 * @author lizeyu
 *
 */
@Service
public class BnousTodayQueryCmd extends DefaultCmd{
	private static Logger logger = LoggerFactory
			.getLogger(BnousTodayQueryCmd.class.getName());
	/**
	 * 查询当天获得的积分
	 * @param request
	 * @param response
	 * @return
	 */
	@CmdMapper({"/querytodaybonus.do"})
	public Object query(XLHttpRequest request,XLHttpResponse response){
		try{
			String userId=request.getParameter("userId","");
			if("".equals(userId)){
				throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1009, "userId为空");
			}
			Integer todayBonus = FacadeFactory.INSTANCE.getBonusTransBo().getTodayBonus(userId);
			
			return JsonObjectUtil.getRtnAndDataJsonObject(0,
					new Ret("00",todayBonus));
		}catch(BonusRuntimeException e){
			logger.error(e.getErrrorCode(), e);
			return JsonObjectUtil.getRtnAndDataJsonObject(0,
					new Ret(e.getErrrorCode(), e.getMessage()));
		}catch(Exception e){
			logger.error("出现异常", e);
			return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret("99",
					"未知错误"));
		}
	}
	
	
	
	public static class Ret{
		private String code;
		private String msg;
		private Integer todayBonus;
		public Ret(String code,String msg){
			this.code=code;
			this.msg=msg;
		}
		public Ret(String code,Integer todayBonus){
			this.code=code;
			this.todayBonus=todayBonus;
		}
		public String getCode() {
			return code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getMsg() {
			return msg;
		}
		public void setMsg(String msg) {
			this.msg = msg;
		}
		public Integer getTodayBonus() {
			return todayBonus;
		}
		public void setTodayBonus(Integer todayBonus) {
			this.todayBonus = todayBonus;
		}
		
	}
}
