package com.xunlei.niux.bonuscenter.cmd;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.bonuscenter.cache.BizInfoCacheManager;
import com.xunlei.niux.data.bonus.exception.BonusRuntimeException;

@Service
public class BizInfoCacheUpdateCmd extends DefaultCmd {
	private static Logger logger = LoggerFactory
			.getLogger(BizInfoCacheUpdateCmd.class.getName());

	@CmdMapper({ "/updatebizinfocache.do" })
	public Object updateCache(XLHttpRequest request, XLHttpResponse response) {
		try {
			BizInfoCacheManager.getInstance().updateCache();
			return JsonObjectUtil.getRtnAndDataJsonObject(0,
					new Ret("00", "成功"));
		} catch (BonusRuntimeException e) {
			logger.error(e.getErrrorCode(), e);
			return JsonObjectUtil.getRtnAndDataJsonObject(0,
					new Ret(e.getErrrorCode(), e.getMessage()));
		} catch (Exception e) {
			logger.error("出现异常", e);
			return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret("99",
					"未知错误"));
		}
	}

	public static class Ret {
		private String code;
		private String msg;

		public Ret(String code, String msg) {
			this.code = code;
			this.msg = msg;
		}

		public String getCode() {
			return code;
		}

		public void setCode(String code) {
			this.code = code;
		}

		public String getMsg() {
			return msg;
		}

		public void setMsg(String msg) {
			this.msg = msg;
		}

	}

}
