package com.xunlei.niux.bonuscenter.cache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang.StringUtils;

import com.xunlei.niux.data.bonus.vo.LotteryInfo;

public class LotteryInfoCacheManager {
	private static LotteryInfoCacheManager instance;
	private static Object lock=new Object();
	private LotteryInfoCacheManager(){
	}
	public static LotteryInfoCacheManager getInstance(){
		if(instance==null){
			synchronized (lock) {
				if(instance==null){
					instance=new LotteryInfoCacheManager();
				}
			}
		}
		return instance;
	}
	
	/**
	 * 获取游戏抽奖信息
	 * @param LotteryInfoNum
	 * @return
	 */
	public LotteryInfo getLotteryInfoCache(int LotteryInfoNum){
		List<LotteryInfo> list = getLotteryInfosCache(String.valueOf(LotteryInfoNum));
		return (list == null || list.size() <= 0) ? null : list.get(0);
	}
	
	/**
	 * 获取所有游戏抽奖信息
	 * @param LotteryInfoNum 欢乐券数量
	 * @return
	 */
	public List<LotteryInfo> getLotteryInfosCache(String LotteryInfoNum){
		List<LotteryInfo> list = new ArrayList<LotteryInfo>();
		
		//列出积分数值的配置
		String[] fields = null;//配置的键（积分数）
		List<String> result = null;//所有配置
		
		if(!StringUtils.isEmpty(LotteryInfoNum) && !"".equals(LotteryInfoNum.trim())){
			fields = new String[]{LotteryInfoNum};
		}else{
			Set<String> keys = JRedisProxy.getInstance().hkeys("LOTTERY_CONF_BONUS");
			if(keys == null){
				return list;
			}
			fields = new String[keys.size()];
			int i = 0;
			for(String key : keys){
				fields[i++] = key;
			}
		}

		//读取缓存中的所有配置的键（积分数）
		try{
			result = JRedisProxy.getInstance().hmget("LOTTERY_CONF_BONUS", fields);
		}catch(Exception e){
		}
		
		Iterator<String> iter = result.iterator();
		int j = 0;
		while(iter.hasNext()){
			String info = iter.next();
			if(info == null){
				continue;
			}
			
			LotteryInfo lotteryInfo = new LotteryInfo();
			
			//取出参数积分数量。（redis以积分数量作为key）
			String bonus = fields[j];
			lotteryInfo.setBonus(Integer.parseInt(bonus));
			
			//积分之外的其他参数
			String[] params = info.split("_");
			if(params != null && params.length > 0){
				lotteryInfo.setSuccsessRate(params[0]);
			}
			
			if(params != null && params.length > 1){
				lotteryInfo.setSuccsessBonus(params[1]);
			}
			
			if(params != null && params.length > 2){
				lotteryInfo.setFailRate(params[2]);
			}
			
			if(params != null && params.length > 3){
				lotteryInfo.setFailBonus(params[3]);
			}
			
			if(params != null && params.length > 4){
				lotteryInfo.setTieRate(params[4]);
			}
			
			if(params != null && params.length > 5){
				lotteryInfo.setTieBonus(params[5]);
			}
			
			if(params != null && params.length > 6){
				lotteryInfo.setInputBy(params[6]);
			}
			
			if(params != null && params.length > 7){
				lotteryInfo.setInputTime(params[7]);
			}
			
			if(params != null && params.length > 8){
				lotteryInfo.setEditBy(params[8]);
			}
			
			if(params != null && params.length > 9){
				lotteryInfo.setEditTime(params[9]);
			}
			
			list.add(lotteryInfo);
			
			j++;
		}
		
		return list;
	}
	
}
