package com.xunlei.niux.bonuscenter.cache;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import org.apache.log4j.Logger;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class JRedisProxy {
	private static JRedisProxy jRedisProxy = new JRedisProxy();
	private static Logger logger = Logger.getLogger("vipLoger");

	public static JRedisProxy getInstance() {
		return jRedisProxy;
	}

	private Properties config = new Properties();
	private JedisPool pool;

	private JRedisProxy() {

		try {
			System.out.println("jredis system连接 初始化");
			config.load(JRedisProxy.class.getClassLoader()
					.getResourceAsStream("jredis.properties"));
			JedisPoolConfig poolConfig = new JedisPoolConfig();
			poolConfig.setMaxActive(Integer.parseInt(config.getProperty(
					"maxActive", "1000")));
			poolConfig.setMaxIdle(Integer.parseInt(config.getProperty(
					"maxIdle", "30")));
			poolConfig.setMaxWait(Integer.parseInt(config.getProperty(
					"maxWait", "1000")));
			poolConfig.setTestOnBorrow(false);
			poolConfig.setTestOnReturn(false);
			pool = new JedisPool(poolConfig, config.getProperty("host"),
					Integer.parseInt(config.getProperty("port", "6379")));
			/*
			 * System.out.println("jredis连接池初始化成功：host=" +
			 * config.getProperty("host") + ",ports=" +
			 * Integer.parseInt(config.getProperty("port", "6379")) +
			 * ",maxActive=" + Integer.parseInt(config.getProperty("maxActive",
			 * "50")) + ",maxIdle=" +
			 * Integer.parseInt(config.getProperty("maxIdle", "10")));
			 */
		} catch (Exception e) {
			System.out.println("jredis system连接池初始化失败");
			e.printStackTrace();
			// logger.info("jredis连接池初始化失败", e);
		}
	}

	public boolean set(final String key, final String value, final int seconds) {
		Jedis jedis = null;
		try {
			jedis = pool.getResource();
			jedis.setex(key, seconds, value);
			return true;
		} catch (Exception e) {
			logger.info("jredisSet异常：key=" + key + ",value=" + value
					+ ",seconds=" + seconds, e);

		} finally {
			if (jedis != null) {
				pool.returnBrokenResource(jedis);
			}
		}
		return false;
	}

	public boolean hmset(final String key, Map<String, String> hash) {
		Jedis jedis = null;
		try {
			jedis = pool.getResource();
			jedis.hmset(key, hash);
			return true;
		} catch (Exception e) {
			logger.info("jredishmset异常：key=" + key + ",hash=" + hash , e);

		} finally {
			if (jedis != null) {
				pool.returnBrokenResource(jedis);
			}
		}
		return false;
	}

	public List<String> hmget(final String key, String... fields) {
		List<String> value = null;
		Jedis jedis = null;
		try {
	
			jedis = pool.getResource();
			value = jedis.hmget(key, fields);

		} catch (Exception e) {
			logger.info("jredishmget异常：key=" + key + ",value=" + value, e);

		} finally {
			if (jedis != null) {
				pool.returnBrokenResource(jedis);
			}
		}
		return value;
	}
	
	public Set<String> hkeys(final String key) {
		Set<String> value = null;
		Jedis jedis = null;
		try {
	
			jedis = pool.getResource();
			value = jedis.hkeys(key);

		} catch (Exception e) {
			logger.info("jredishmget异常：key=" + key + ",value=" + value, e);

		} finally {
			if (jedis != null) {
				pool.returnBrokenResource(jedis);
			}
		}
		return value;
	}
	
	public String get(final String key) {
		String value = null;
		Jedis jedis = null;
		try {
	
			jedis = pool.getResource();
			value=jedis.get(key);

		} catch (Exception e) {
			logger.info("jredisget异常：key=" + key + ",value=" + value, e);

		} finally {
			if (jedis != null) {
				pool.returnBrokenResource(jedis);
			}
		}
		return value;
	}

	public void del(final String key) {

		Jedis jedis = null;
		try {
			jedis = pool.getResource();
			jedis.del(key);

		} catch (Exception e) {
			logger.info("jredisdel异常：key=" + key, e);

		} finally {
			if (jedis != null) {
				pool.returnBrokenResource(jedis);
			}
		}

	}

	public boolean exists(final String key) {
		Jedis jedis = null;
		try {
			jedis = pool.getResource();
			long ttl=jedis.ttl(key);
			if(ttl>0){
				return true;
			}else{
				return false;
			}
					
		} catch (Exception e) {
			logger.info("jredisEsists异常：key=" + key, e);

		} finally {
			if (jedis != null) {
				pool.returnBrokenResource(jedis);
			}
		}
		return false;
	}

	public boolean incr(final String key) {
		Jedis jedis = null;
		try {
			jedis = pool.getResource();
			jedis.incr(key);
			return true;
		} catch (Exception e) {
			logger.info("jredisIncr异常：key=" + key);
		} finally {
			if (jedis != null) {
				pool.returnBrokenResource(jedis);
			}
		}
		return false;
	}
	
	public Long sadd(int seconds, String key, String... members){
		Jedis jedis = null;
		long result = 0L;
		try {
			jedis = pool.getResource();
			result = jedis.sadd(key,members);
			if(result==1){
				jedis.expire(key, seconds);
			}
		} catch (Exception e) {
			logger.info("jredisCreate异常：key=" + key);
		} finally {
			if (jedis != null) {
				pool.returnBrokenResource(jedis);
			}
		}
		return result;
	}
	
	public Long sadd(String key, String... members){
		Jedis jedis = null;
		try {
			jedis = pool.getResource();
			return jedis.sadd(key,members);
		} catch (Exception e) {
			logger.info("jredisSadd异常：key=" + key);
		} finally {
			if (jedis != null) {
				pool.returnBrokenResource(jedis);
			}
		}
		return 0L;
	}
	
	public Long scard(String key){
		Jedis jedis = null;
		try {
			jedis = pool.getResource();
			return jedis.scard(key);
		} catch (Exception e) {
			logger.info("jredisScard异常：key=" + key);
		} finally {
			if (jedis != null) {
				pool.returnBrokenResource(jedis);
			}
		}
		return 0L;
	}
	
	public Set<String> smembers(String key){
		Jedis jedis = null;
		try {
			jedis = pool.getResource();
			return jedis.smembers(key);
		} catch (Exception e) {
			logger.info("jredisScard异常：key=" + key);
		} finally {
			if (jedis != null) {
				pool.returnBrokenResource(jedis);
			}
		}
		return null;
	}
	
	public boolean monitor() {
		Jedis jedis = null;
		try {
			jedis = (Jedis)this.pool.getResource();
			String key = "LYGameSvr_com_xunlei_game_proxy_JRedisProxy_QCAEJA8A5MRFDBSLYFVP1NE3UDWZL8OD";
			jedis.setex("LYGameSvr_com_xunlei_game_proxy_JRedisProxy_QCAEJA8A5MRFDBSLYFVP1NE3UDWZL8OD", 600, "");
			return exists("LYGameSvr_com_xunlei_game_proxy_JRedisProxy_QCAEJA8A5MRFDBSLYFVP1NE3UDWZL8OD");
		} catch (Exception e) {
			logger.info("redis monitor异常：", e);
		} finally {
			if (jedis != null) {
				this.pool.returnBrokenResource(jedis);
			}
		}
		return false;
	}
	
	public String info() {
		String value = null;
		Jedis jedis = null;
		try {
			jedis = (Jedis)this.pool.getResource();
			value = jedis.info();
			} catch (Exception e) {
				logger.info("redis info异常", e);
				} finally {
					if (jedis != null) {
						this.pool.returnBrokenResource(jedis);
						}
					}
		return value;
	}
	
	public void test(){
		 try {
		Jedis	jedis = pool.getResource();
		if(this.exists("000120_1_ROLE_FIGHT")){
        System.out.println(true);// 检查key是否存在   
        }
        pool.returnBrokenResource(jedis);
        }catch( Exception e){
        	e.printStackTrace();
        }

	}
	

	public static void main(final String[] args) {
		JRedisProxy.getInstance().test();
	}
}
