package com.xunlei.niux.bonuscenter.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.bonus.facade.FacadeFactory;
import com.xunlei.niux.data.bonus.vo.BonusLevel;

public class BonusLevelCacheManager {
	private static BonusLevelCacheManager instance;
	private static Object lock=new Object();
	private Map<Integer,BonusLevelCache> bonusLevelCacheMap=new HashMap<Integer,BonusLevelCache>();
	private BonusLevelCacheManager(){
		updateCache();
	}
	public static BonusLevelCacheManager getInstance(){
		if(instance==null){
			synchronized (lock) {
				if(instance==null){
					instance=new BonusLevelCacheManager();
				}
			}
		}
		return instance;
	}
	/**
	 * 获取游戏级别信息
	 * @param levelNum
	 * @return
	 */
	public BonusLevelCache getBonusLevelCache(int levelNum){
		return bonusLevelCacheMap.get(levelNum);
	}
	/**
	 * 更新缓存
	 */
	public void updateCache(){
		List<BonusLevel> list=FacadeFactory.INSTANCE.getBonusLevelBo().find(new BonusLevel(), new Page());
		if(list==null){
			list=new ArrayList<BonusLevel>();
		}
		Map<Integer,BonusLevelCache> tempMap=new HashMap<Integer,BonusLevelCache>();
		for(BonusLevel level:list){
			BonusLevelCache cache=new BonusLevelCache();
			cache.setLevelNum(level.getLevelNum());
			cache.setLevelName(level.getLevelName());
			cache.setLevelUrl(level.getLevelIconUrl());
			cache.setMinBonusNum(level.getMinBonusNum());
			cache.setSumUserNum(level.getSumUserNum());
			tempMap.put(level.getLevelNum(), cache);
		}
		bonusLevelCacheMap=tempMap;
	}
	public static class BonusLevelCache{
		private int levelNum;
		private String levelName;
		private String levelUrl;
		private int minBonusNum;
		private int sumUserNum;
		
		public int getSumUserNum() {
			return sumUserNum;
		}
		public void setSumUserNum(int sumUserNum) {
			this.sumUserNum = sumUserNum;
		}
		public int getLevelNum() {
			return levelNum;
		}
		 void setLevelNum(int levelNum) {
			this.levelNum = levelNum;
		}
		public String getLevelName() {
			return levelName;
		}
		 void setLevelName(String levelName) {
			this.levelName = levelName;
		}
		 public String getLevelUrl() {
			return levelUrl;
		}
		 void setLevelUrl(String levelUrl) {
			this.levelUrl = levelUrl;
		}
		public int getMinBonusNum() {
			return minBonusNum;
		}
		 void setMinBonusNum(int minBonusNum) {
			this.minBonusNum = minBonusNum;
		}
		
	}
}
