package com.xunlei.niux.bonuscenter.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.xunlei.niux.data.bonus.exception.BonusErrorCode;
import com.xunlei.niux.data.bonus.exception.BonusRuntimeException;
import com.xunlei.niux.data.bonus.facade.FacadeFactory;
import com.xunlei.niux.data.bonus.vo.BizInfo;

/**
 * 业务信息缓存控制
 * @author Administrator
 *
 */
public class BizInfoCacheManager {
	private static BizInfoCacheManager instance;
	private static Object lock=new Object();
	private static Map<String,BizInfoCache> bizInfoCacheMap=new HashMap<String,BizInfoCache>();
	private BizInfoCacheManager(){
		updateCache();
	}
	public static BizInfoCacheManager getInstance(){
		if(instance==null){
			synchronized (lock) {
				if(instance==null){
					instance=new BizInfoCacheManager();
				}
			}
		}
		return instance;
	}
	public BizInfoCache getBizInfoCache(String bizNo){
		return bizInfoCacheMap.get(bizNo);
	}
	/**
	 * 获取bizNo对应的业务信息，并且验证是否有效。如果无效抛出异常
	 * @param bizNo
	 * @return
	 */
	public BizInfoCache getAndcheckBizInfoValid(String bizNo,String clientIp){
		BizInfoCache bizInfocache=bizInfoCacheMap.get(bizNo);
		if(bizInfocache==null){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1010, "业务["+bizNo+"]不存在");
		}
		if(bizInfocache.getIsValid()!=true){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1011, "业务["+bizNo+"]不可用");
		}
		if(bizInfocache.getBizIp()==null||"".equals(bizInfocache.getBizIp())){
			return bizInfocache;
		}
		if(bizInfocache.getBizIp().indexOf(clientIp)<0){
			throw new BonusRuntimeException(BonusErrorCode.BONUS_CODE_1013, "IP["+clientIp+"]限制业务["+bizNo+"]");
		}
		return bizInfocache;
	}
	/**
	 * 更新缓存
	 */
	public void updateCache(){
		List<BizInfo> list=FacadeFactory.INSTANCE.getBizInfoBo().find(new BizInfo());
		Map<String,BizInfoCache> bizInfoCacheTempMap=new HashMap<String,BizInfoCache>();
		if(list==null){
			list=new ArrayList<BizInfo>();
		}
		for(BizInfo bizInfo:list){
			BizInfoCache cache=new BizInfoCache();
			cache.setBizNo(bizInfo.getBizNo());
			cache.setBizPwd(bizInfo.getBizPwd());
			cache.setBizIp(bizInfo.getBizIp());
			cache.setIsValid(bizInfo.getIsValid());
			bizInfoCacheTempMap.put(bizInfo.getBizNo(), cache);
		}
		bizInfoCacheMap=bizInfoCacheTempMap;
	}
	public static class BizInfoCache{
		private String bizNo;
		private String bizPwd;
		private Boolean isValid;
		private String bizIp;
		public String getBizNo() {
			return bizNo;
		}
		void setBizNo(String bizNo) {
			this.bizNo = bizNo;
		}
		public String getBizPwd() {
			return bizPwd;
		}
	    void setBizPwd(String bizPwd) {
			this.bizPwd = bizPwd;
		}
		public Boolean getIsValid() {
			return isValid;
		}
		void setIsValid(Boolean isValid) {
			this.isValid = isValid;
		}
		public String getBizIp() {
			return bizIp;
		}
		void setBizIp(String bizIp) {
			this.bizIp = bizIp;
		}
		
	}
}
