package com.xunlei.niux.bonuscenter;

import java.io.InputStream;
import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;

import com.mchange.v2.c3p0.ComboPooledDataSource;

public class JndiCommonProvider {
	 private static String fileName = "/dbjndi.properties";
	 private JndiCommonProvider() {
	 }
     public static void init() throws Exception {
        Properties prop= new Properties();
        InputStream is = Object.class.getResourceAsStream(fileName);
        prop.load(is);
        if(is!=null) {
        	is.close();
        }

        System.setProperty(Context.INITIAL_CONTEXT_FACTORY, "com.xunlei.org.apache.naming.java.javaURLContextFactory");
        System.setProperty(Context.URL_PKG_PREFIXES, "com.xunlei.org.apache.naming");
        Context context = new InitialContext();
        context.createSubcontext("java:comp").createSubcontext("env").createSubcontext("jdbc");

        int poolSize = Integer.parseInt(prop.getProperty("poolsize"));
        for(int i=1; i<=poolSize; i++) {
        	ComboPooledDataSource source = new ComboPooledDataSource();
        	source.setDriverClass("com.mysql.jdbc.Driver");
        	source.setJdbcUrl(prop.getProperty("pool" + i + ".url"));
            source.setUser(prop.getProperty("pool" + i + ".user"));
            source.setPassword(prop.getProperty("pool" + i + ".password"));
            source.setIdleConnectionTestPeriod(18000);
            source.setMaxPoolSize(100);
            source.setMinPoolSize(5);
            source.setInitialPoolSize(5);
            source.setCheckoutTimeout(10000);
            source.setMaxIdleTime(25000);
            source.setTestConnectionOnCheckin(true);
            
            ((Context)context.lookup("java:comp/env/jdbc")).rebind(prop.getProperty("pool" + i + ".jndiName"), source);
            System.out.println("jndiName:" + prop.getProperty("pool" + i + ".jndiName"));
        }
    }
}
