package com.xunlei.niux.easyutils.propertyutils;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ResourceBundle;

/**
 * Created by jamesjxin on 14-12-31.
 */
public class EnvPropertyUtil {
    private static Logger logger = LoggerFactory.getLogger(EnvPropertyUtil.class);

    private static String env;

    static{

        try {
            env = ResourceBundle.getBundle("env").getString("env");
            if(env == null){
                env = "";
            }
        } catch (Exception e) {
            logger.error("get env.properties Exception",e);
            env = "";
        }
    }

    public static String getEnv(){
        return env;
    }



    public static String loadProperty(String propertiesFileName,String keyName){
        try{
            String filePath;
            if(StringUtils.isEmpty(env)){
                filePath = propertiesFileName;
            }else {
                filePath = env+"/"+propertiesFileName;
            }
            ResourceBundle rb=ResourceBundle.getBundle(filePath);
            return rb.getString(keyName);
        }catch(Exception e){
            logger.error("配置文件{"+propertiesFileName+"}key{"+keyName+"}不存在",e);
            return "";
        }

    }
    public static String loadProperty(String propertiesFileName,String keyName,String defaultValue){
        String value=loadProperty(propertiesFileName, keyName);
        return StringUtils.isEmpty(value)?defaultValue:value;
    }

    public static Integer loadIntProperty(String propertiesFileName,String keyName){
        String value=loadProperty(propertiesFileName, keyName);
        int val;
        try {
            val = Integer.valueOf(value);
        } catch (NumberFormatException e) {
            logger.error("配置文件{" + propertiesFileName + "}key{" + keyName + "} getInteger NumberFormatException", e);
            val = 0;
        }
        return val;
    }
}
