package com.xunlei.niux.easyutils.commonutils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @author hezhong
 */
public class DateUtil {

    private static final String TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_PATTERN = "yyyy-MM-dd";

    private static ThreadLocal timeThreadLocal = new ThreadLocal(){
        protected Object initialValue() {
            return null;//直接返回null
        }
    };

    private static ThreadLocal dateThreadLocal = new ThreadLocal(){
        protected Object initialValue() {
            return null;//直接返回null
        }
    };

    public static DateFormat getTimeFormat() {
        DateFormat df = (DateFormat) timeThreadLocal.get();
        if (df == null) {
            df = new SimpleDateFormat(TIME_PATTERN);
            timeThreadLocal.set(df);
        }
        return df;
    }

    public static DateFormat getDateFormat() {
        DateFormat df = (DateFormat) dateThreadLocal.get();
        if (df == null) {
            df = new SimpleDateFormat(DATE_PATTERN);
            dateThreadLocal.set(df);
        }
        return df;
    }


	public static String getOrderTime(){
		return getTimeFormat().format(new Date());
	}

    public static Date yesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DAY_OF_YEAR, -1);

        return calendar.getTime();
    }

    public static String formatNow(String pattern) {
       return format(new Date(), pattern);
    }


    public static String formatNowByDefault() {
        return formatNow(TIME_PATTERN);
    }

    public static Date nextYear() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.YEAR, 1);

        return calendar.getTime();
    }

    public static  String format(Date date, String pattern) {
        DateFormat dateFormat = new SimpleDateFormat(pattern);

        return dateFormat.format(date);
    }

    
    /**
	 * 比较两个时间相隔多少天
	 *  add by lisu 2013-05-08
	 * @param fromtime 格式 yyyy-MM-dd
	 * @param totime   格式 yyyy-MM-dd
	 * @return
	 */
	public static long compareTime(String fromtime,String totime){
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");  
        Date one = null;
        Date two = null;
        long days=0;  
        try{
        	one = df.parse(fromtime);  
        	two = df.parse(totime); 
        	long time1 = one.getTime();  
        	long time2 = two.getTime();  
        	long diff = time1 - time2;
        	days = diff / (1000 * 60 * 60 * 24);  
        }catch(ParseException  e){
        	e.printStackTrace();  
        }
		return days;
	}
	
}
