/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.easyutils.propertyutils;

import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvPropertyUtil {
    private static Logger logger = LoggerFactory.getLogger(EnvPropertyUtil.class);
    private static String env;

    public static String getEnv() {
        return env;
    }

    public static String loadProperty(String propertiesFileName, String keyName) {
        try {
            String filePath = StringUtils.isEmpty((String)env) ? propertiesFileName : env + "/" + propertiesFileName;
            ResourceBundle rb = ResourceBundle.getBundle(filePath);
            return rb.getString(keyName);
        }
        catch (Exception e) {
            logger.error("\u914d\u7f6e\u6587\u4ef6{" + propertiesFileName + "}key{" + keyName + "}\u4e0d\u5b58\u5728", (Throwable)e);
            return "";
        }
    }

    public static String loadProperty(String propertiesFileName, String keyName, String defaultValue) {
        String value = EnvPropertyUtil.loadProperty(propertiesFileName, keyName);
        return StringUtils.isEmpty((String)value) ? defaultValue : value;
    }

    public static Integer loadIntProperty(String propertiesFileName, String keyName) {
        int val;
        String value = EnvPropertyUtil.loadProperty(propertiesFileName, keyName);
        try {
            val = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            logger.error("\u914d\u7f6e\u6587\u4ef6{" + propertiesFileName + "}key{" + keyName + "} getInteger NumberFormatException", (Throwable)e);
            val = 0;
        }
        return val;
    }

    static {
        try {
            env = ResourceBundle.getBundle("env").getString("env");
            if (env == null) {
                env = "";
            }
        }
        catch (Exception e) {
            logger.error("get env.properties Exception", (Throwable)e);
            env = "";
        }
    }
}

