/**
 * 
 */
package com.xunlei.niux.currency.api.dto;

/**
 * 交易退款信息
 * 
 * @author wangcanyi
 *
 */
public class TransRefundDTO {
	private Long seqId;
	private Integer refundType;
	private String transFromId;
	private String transToId;
	private String gameId;
	private Double transCousumeValue;
	private Double discount;
	private Double transRechargeValue;
	private Integer checkStatus;
	private String orderId;
	private String remark;
	private String checkBy;
	private String checkTime;
	private Integer isValid;
	private String inputBy;
	private String inputTime;
	private String editBy;
	private String editTime;
	/**
	 * @return 主键
	 */
	public Long getSeqId() {
		return seqId;
	}
	/**
	 * @param seqId 主键
	 */
	public void setSeqId(Long seqId) {
		this.seqId = seqId;
	}
	/**
	 * @return 退款类型：1.绑银退牛币
	 */
	public Integer getRefundType() {
		return refundType;
	}
	/**
	 * @param refundType 退款类型：1.绑银退牛币
	 */
	public void setRefundType(Integer refundType) {
		this.refundType = refundType;
	}
	/**
	 * @return 迅雷UID，被退回者
	 */
	public String getTransFromId() {
		return transFromId;
	}
	/**
	 * @param transFromId 迅雷UID，被退回者
	 */
	public void setTransFromId(String transFromId) {
		this.transFromId = transFromId;
	}
	/**
	 * @return 迅雷UID，退回到谁
	 */
	public String getTransToId() {
		return transToId;
	}
	/**
	 * @param transToId 迅雷UID，退回到谁
	 */
	public void setTransToId(String transToId) {
		this.transToId = transToId;
	}
	/**
	 * @return 游戏Id
	 */
	public String getGameId() {
		return gameId;
	}
	/**
	 * @param gameId 游戏Id
	 */
	public void setGameId(String gameId) {
		this.gameId = gameId;
	}
	/**
	 * @return 退回交易点数
	 */
	public Double getTransCousumeValue() {
		return transCousumeValue;
	}
	/**
	 * @param transCousumeValue 退回交易点数
	 */
	public void setTransCousumeValue(Double transCousumeValue) {
		this.transCousumeValue = transCousumeValue;
	}
	/**
	 * @return 当前折扣，百分比
	 */
	public Double getDiscount() {
		return discount;
	}
	/**
	 * @param discount 当前折扣，百分比
	 */
	public void setDiscount(Double discount) {
		this.discount = discount;
	}
	/**
	 * @return 实退交易点数（退回交易点数 * 折扣）（可手调）
	 */
	public Double getTransRechargeValue() {
		return transRechargeValue;
	}
	/**
	 * @param transRechargeValue 实退交易点数（退回交易点数 * 折扣）（可手调）
	 */
	public void setTransRechargeValue(Double transRechargeValue) {
		this.transRechargeValue = transRechargeValue;
	}
	/**
	 * @return 审核状态 0.未审核 1.审核通过
	 */
	public Integer getCheckStatus() {
		return checkStatus;
	}
	/**
	 * @param checkStatus 审核状态 0.未审核 1.审核通过
	 */
	public void setCheckStatus(Integer checkStatus) {
		this.checkStatus = checkStatus;
	}
	/**
	 * @return 业务申请号，业务方内唯一的业务申请号
	 */
	public String getOrderId() {
		return orderId;
	}
	/**
	 * @param orderId 业务申请号，业务方内唯一的业务申请号
	 */
	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}
	/**
	 * @return 备注
	 */
	public String getRemark() {
		return remark;
	}
	/**
	 * @param remark 备注
	 */
	public void setRemark(String remark) {
		this.remark = remark;
	}
	/**
	 * @return 审核人
	 */
	public String getCheckBy() {
		return checkBy;
	}
	/**
	 * @param checkBy 审核人
	 */
	public void setCheckBy(String checkBy) {
		this.checkBy = checkBy;
	}
	/**
	 * @return 审核时间
	 */
	public String getCheckTime() {
		return checkTime;
	}
	/**
	 * @param checkTime 审核时间
	 */
	public void setCheckTime(String checkTime) {
		this.checkTime = checkTime;
	}
	/**
	 * @return 是否有效 1.是 0.否
	 */
	public Integer getIsValid() {
		return isValid;
	}
	/**
	 * @param isValid 是否有效 1.是 0.否
	 */
	public void setIsValid(Integer isValid) {
		this.isValid = isValid;
	}
	/**
	 * @return 录入人
	 */
	public String getInputBy() {
		return inputBy;
	}
	/**
	 * @param inputBy 录入人
	 */
	public void setInputBy(String inputBy) {
		this.inputBy = inputBy;
	}
	/**
	 * @return 录入时间
	 */
	public String getInputTime() {
		return inputTime;
	}
	/**
	 * @param inputTime 录入时间
	 */
	public void setInputTime(String inputTime) {
		this.inputTime = inputTime;
	}
	/**
	 * @return 编辑人
	 */
	public String getEditBy() {
		return editBy;
	}
	/**
	 * @param editBy 编辑人
	 */
	public void setEditBy(String editBy) {
		this.editBy = editBy;
	}
	/**
	 * @return 编辑时间
	 */
	public String getEditTime() {
		return editTime;
	}
	/**
	 * @param editTime 编辑时间
	 */
	public void setEditTime(String editTime) {
		this.editTime = editTime;
	}
}
