/**
 * 
 */
package com.xunlei.niux.currency.api;

import java.io.IOException;
import java.util.Properties;

import com.xunlei.netty.soaserver.client.SOAClientFactory;

/**
 * 服务工厂
 * 
 * @author wangcanyi
 *
 */
public class ServiceFactory {
	public static final ServiceFactory INSTANCE = new ServiceFactory();

	private static final String appName = "xlniux_currency_base";

	public ServiceFactory() {
		SOAClientFactory soaClient = this.getSOAClientFactory();
		this.bindSilverService = (IBindSilverService) soaClient.getObject(IBindSilverService.class);
		this.userSecurityService = (IUserSecurityService) soaClient.getObject(IUserSecurityService.class);
	}

	/**
	 * 获取SOA客户端工厂
	 * 
	 * @return
	 */
	private SOAClientFactory getSOAClientFactory() {
		Properties config = this.getServiceClientProperties();
		SOAClientFactory soaClient = new SOAClientFactory();
		soaClient.setAppName(appName);
		soaClient.setServiceHost(config.getProperty("ServiceHost"));
		soaClient.setServicePort(Integer.parseInt(config.getProperty("ServicePort")));
		return soaClient;
	}

	/**
	 * 获取服务客户端配置
	 * 
	 * @return
	 */
	private Properties getServiceClientProperties() {
		Properties config = new Properties();
		try {
			config.load(ServiceFactory.class.getClassLoader().getResourceAsStream("com/xunlei/niux/currency/api/properties/serviceClient.properties"));
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return config;
	}

	private IBindSilverService bindSilverService;
	private IUserSecurityService userSecurityService;

	/**
	 * @return 绑银服务
	 */
	public IBindSilverService getBindSilverService() {
		return bindSilverService;
	}

	/**
	 * @return 用户安全服务
	 */
	public IUserSecurityService getUserSecurityService() {
		return userSecurityService;
	}
}
