/**
 * 
 */
package com.xunlei.niux.currency.api;

import java.util.List;

import com.xunlei.netty.soaserver.cmd.annotation.CmdSOAInterface;
import com.xunlei.netty.soaserver.component.SOAPageResponse;
import com.xunlei.netty.soaserver.component.SOAResponse;
import com.xunlei.niux.currency.api.arg.TransRefundDTOArg;
import com.xunlei.niux.currency.api.dto.NYTransConsumeDTO;
import com.xunlei.niux.currency.api.dto.TransRefundCheckDTO;
import com.xunlei.niux.currency.api.dto.TransRefundDTO;

/**
 * 金钻特权服务
 * 
 * @author wangcanyi
 *
 */
@CmdSOAInterface
public interface IBindSilverService {

	/**
	 * 新增修改 绑银退回牛币
	 * 
	 * @param arg
	 * @return
	 */
	TransRefundDTO doRefundByBYToNB(TransRefundDTO arg) throws Exception;

	/**
	 * 绑银退回牛币 审核通过
	 * 
	 * @param seqId
	 * @return
	 */
	List<TransRefundDTO> doRefundCheckPassByBYToNB(List<Long> seqIdList, String checkBy) throws Exception;

	/**
	 * 删除回退信息
	 * 
	 * @param seqId
	 * @param editBy
	 * @return
	 */
	List<TransRefundDTO> deleteTransRefund(List<Long> seqIdList, String editBy) throws Exception;

	/**
	 * 验证交易退款信息
	 * 
	 * @param arg
	 * @return
	 */
	TransRefundCheckDTO checkTransRefund(TransRefundDTO arg);

	/**
	 * 根据参数，查询绑银退回牛币信息
	 * 
	 * @param arg
	 * @return
	 */
	SOAPageResponse<TransRefundDTO> findTransRefund(TransRefundDTOArg arg);
	
	/**
	 * 获取绑银牛币组合消费记录
	 * @param bizNo
	 * @param orderId
	 * @return
	 */
	NYTransConsumeDTO getNYTransConsume(String bizNo, String orderId) throws Exception;
}
