package com.xunlei.niux.client.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.slf4j.Logger;

import com.xunlei.util.Log;

/**
 * 通过JAVA访问
 * 
 * @author Administrator
 * 
 */
public class URLUtil {
	private static Logger logger = Log.getLogger(URLUtil.class);

	public static String get(String pUrl, URLProperty property) {
		BufferedReader bin = null;
		try {
			long beginTime = System.currentTimeMillis();// 开始执行时间
			URL url = new URL(pUrl);
			// 设置参数
			HttpURLConnection urlcon = (HttpURLConnection) url.openConnection();
			urlcon.setConnectTimeout(property.getConnectTimeout());
			urlcon.setReadTimeout(property.getReadTimeout());
			bin = new BufferedReader(new InputStreamReader(
					urlcon.getInputStream(), property.getCharSet()));
			StringBuilder respsb = new StringBuilder();
			String s = null;
			while ((s = bin.readLine()) != null) {
				respsb.append(s);
			}
			logger.info("request[" + pUrl + "]spent time["
					+ (System.currentTimeMillis() - beginTime) + "]resp:"
					+ respsb.toString());
			return respsb.toString();
		} catch (MalformedURLException e) {
			logger.error("request[" + pUrl + "] exception:" + e.getMessage());
			throw new RuntimeException(e);
		} catch (IOException e) {
			logger.error("request[" + pUrl + "] exception:" + e.getMessage());
			throw new RuntimeException(e);
		} finally {
			if (bin != null) {
				try {
					bin.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	public static String get(String pUrl) {
		return get(pUrl, new URLProperty());
	}

	public static String post(String urlStr, Map<String, String> paramMap,
			Map<String, String> cookieMap) throws Exception {
		URLProperty property=new URLProperty();
		URLConnection conn = null;
		OutputStreamWriter writer = null;
		BufferedReader breader = null;
		try {
			URL url = new URL(urlStr);
			conn = url.openConnection();
			conn.setDoOutput(true);
			conn.setDoInput(true);
			conn.setConnectTimeout(property.getConnectTimeout());
			conn.setReadTimeout(property.getReadTimeout());
			// 设置cookie
			String cookieStr = getCookieStr(cookieMap);
			if (cookieStr.length() > 0) {
				conn.setRequestProperty("Cookie", cookieStr);
			}

			String params = getHttpParam(paramMap);
			writer = new OutputStreamWriter(conn.getOutputStream());
			writer.write(params);
			writer.flush();
			writer.close();
			writer = null;

			breader = new BufferedReader(new InputStreamReader(
					conn.getInputStream(), "UTF-8"));
			String content = null;
			String result = "";
			while ((content = breader.readLine()) != null) {
				result += content;
			}
			logger.info("post request url:["+urlStr+"]params["+params+"]coolie["+cookieStr+"]result["+result+"]");
			return result;
		} catch (MalformedURLException e) {
			throw e;
		} catch (IOException e) {
			throw e;
		} finally {
			if (writer != null) {
				writer.close();
			}
			if (breader != null) {
				breader.close();
			}
		}
	}

	/**
	 * 获取cookie字符串
	 * 
	 * @param cookieMap
	 * @return
	 */
	public static String getCookieStr(Map<String, String> cookieMap) {
		if (cookieMap == null || cookieMap.isEmpty()) {
			return "";
		}
		StringBuilder sb = new StringBuilder();
		Set<String> keySet = cookieMap.keySet();
		Iterator<String> it = keySet.iterator();
		while (it.hasNext()) {
			String key = it.next();
			String value = cookieMap.get(key);
			if (value == null || "".equals(value)) {
				continue;
			}
			sb.append(key).append("=").append(value).append(";");
		}
		return sb.toString();
	}

	/**
	 * 获取http的参数字符串
	 * 
	 * @param paramMap
	 * @return
	 */
	public static String getHttpParam(Map<String, String> paramMap) {
		if (paramMap == null || paramMap.isEmpty()) {
			return "";
		}
		StringBuilder sb = new StringBuilder();
		Set<String> keySet = paramMap.keySet();
		Iterator<String> it = keySet.iterator();
		while (it.hasNext()) {
			String key = it.next();
			String value = paramMap.get(key);
			value = value == null ? "" : value;
			sb.append(key).append("=").append(value).append("&");
		}
		return sb.toString();
	}

	public static class URLProperty {
		private String charSet = "UTF-8";// 编号格式
		private int connectTimeout = 3000;// 毫秒
		private int readTimeout=20000;//读超时，单位毫秒
		public int getConnectTimeout() {
			return connectTimeout;
		}

		public void setConnectTimeout(int connectTimeout) {
			this.connectTimeout = connectTimeout;
		}
		
		public String getCharSet() {
			return charSet;
		}

		public void setCharSet(String charSet) {
			this.charSet = charSet;
		}

		public int getReadTimeout() {
			return readTimeout;
		}

		public void setReadTimeout(int readTimeout) {
			this.readTimeout = readTimeout;
		}
	}
}
