package com.xunlei.niux.client.util;

import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;

import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class HttpClientUtil {

    public static String getHtml(String url)
            throws Exception
    {
        HttpGet httpGet = new HttpGet(url);

        String responseString = "";
        HttpEntity entity = null;
        try {
            DefaultHttpClient httpClient = new DefaultHttpClient();
            httpClient.getParams().setParameter("http.protocol.content-charset", "UTF-8");
            HttpResponse response = httpClient.execute(httpGet);

            responseString = EntityUtils.toString(response.getEntity(), HTTP.UTF_8);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (entity != null) {
                entity.consumeContent();
            }
        }
        return responseString;
    }

    public static String get(String url,String action){
        return URLUtil.get(url + action);
    }
    public static String get(String url){
        return URLUtil.get(url);
    }
    public static String decode(String value){
        if(value==null){
            return value;
        }
        try {
            return URLDecoder.decode(value, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }
    private static String encode(String value){
    	if(value==null){
    		return value;
    	}
    	try {
			return URLEncoder.encode(value, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
			return "";
		}
    }
    public static String post(String urlStr,String body)throws Exception {
    	 URL url = new URL(urlStr);  
         URLConnection urlConnection = url.openConnection();  
         // 设置doOutput属性为true表示将使用此urlConnection写入数据  
         urlConnection.setDoOutput(true);  
         // 定义待写入数据的内容类型，我们设置为application/x-www-form-urlencoded类型  
         urlConnection.setRequestProperty("content-type", "application/x-www-form-urlencoded");  
         // 得到请求的输出流对象  
         OutputStreamWriter out = new OutputStreamWriter(urlConnection.getOutputStream(),"UTF-8");  
         // 把数据写入请求的Body  
         out.write(body);  
         out.flush();  
         out.close();  
           
         // 从服务器读取响应  
         InputStream inputStream = urlConnection.getInputStream();  
         String encoding = urlConnection.getContentEncoding();  
         String resp = IOUtils.toString(inputStream, encoding);  
    	return resp;
    }
    public static void main(String[] args){
//        String i="\u5c0a\u656c\u7684\u7528\u6237\uff0c\u60a8\u73b0\u5728\u8fd8\u6ca1\u6709\u83b7\u5f97\u8fc7\u73b0\u91d1\u5238\u3002";
//        System.out.println(decode(i));
//    	String str="{ \"button\":[{\"name\":\"游戏礼包\",\"sub_button\":[{\"type\":\"click\",\"name\":\"所有礼包\",\"key\":\"1_allgift\"}]},{\"name\":\"精彩活动\",\"sub_button\":[{\"type\":\"click\",\"name\":\"最新开服\",\"key\":\"2_1\"},{\"type\":\"click\",\"name\":\"最新活动\",\"key\":\"2_2\"},{\"type\":\"click\",\"name\":\"推荐游戏\",\"key\":\"2_3\"}]},{\"type\": \"view\",  \"name\": \"手游中心\",\"url\": \"http://niu.xunlei.com/mobile/mpg/\" }]}";
//    	String url="https://api.weixin.qq.com/cgi-bin/menu/create?access_token=Vrr433EosWyKmSFBe7H_-VeomglPyNcDBdwbceRXMfVXCL_gwn61Z3dm_mMF6ymc";
//    	String str="{\"touser\":\"oWSUBjwhRIoCM63ZvVs9AbPn02_8\",\"msgtype\":\"news\", \"news\":{\"articles\":[{\"title\":\"测试\",\"description\":\"Is Really A Happy Day\",\"url\":\"http://niu.xunlei.com/mobile/mpg/\", \"picurl\":\"http://i2.webgame.kanimg.com/20140321/1395394502495.jpg\"}]}}";
//    	String url="https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=dybZh4lizFMYvuteDT1hfd_55kocATUFh4Aa62Upfzx7NXhHhu3_Oj2NIig5aKad";
    	String url="http://10.10.10.202/weixin/checkToken.do?signature=04ab2b6ce3af61f753fb5fd10101e14febe7c2f4&timestamp=123456&nonce=2nonce&echostr=echostr";
//    	String str="<xml><FromUserName>oWSUBjwhRIoCM63ZvVs9AbPn02_8</FromUserName><MsgType>event</MsgType><EventKey>1_allgift</EventKey></xml>";
    	String str="<xml><FromUserName>oWSUBjwhRIoCM63ZvVs9AbPn02_8</FromUserName><MsgType>text</MsgType><Content>1</Content></xml>";
    	try {
			System.out.println(post(url,str));
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    }
}