package com.xunlei.niux.client.mail;

import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

import java.util.Properties;

/**
 * Created by jamesjxin on 15-3-20.
 */
public class MailSendClient {
    private String host;
    private String fromUserName;
    private String fromPassword;
    private JavaMailSender javaMailSender;

    public MailSendClient(String host, String fromUserName, String fromPassword) {
        this.fromPassword = fromPassword;
        this.fromUserName = fromUserName;
        this.host = host;
        initMailSender();
    }

    public MailSendClient(){
        host = "mail.xunlei.com";
        fromUserName = "xlniux@xunlei.com";
        fromPassword = "13eh6a1m";

        initMailSender();
    }

    private void initMailSender(){
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setHost(host);
        Properties prop = new Properties();
        prop.setProperty("mail.smtp.auth", "true");
        prop.setProperty("mail.smtp.timeout", "10000");
        mailSender.setJavaMailProperties(prop);
        mailSender.setUsername(fromUserName);
        mailSender.setPassword(fromPassword);
        javaMailSender = mailSender;
    }

    public void sendMail(String subject,String context,String... addr){
        SimpleMailMessage mailMessage = new SimpleMailMessage();
        mailMessage.setTo(addr);
        mailMessage.setFrom(fromUserName);
        mailMessage.setSubject(subject);
        mailMessage.setText(context);
        javaMailSender.send(mailMessage);
    }



    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getFromUserName() {
        return fromUserName;
    }

    public void setFromUserName(String fromUserName) {
        this.fromUserName = fromUserName;
    }

    public String getFromPassword() {
        return fromPassword;
    }

    public void setFromPassword(String fromPassword) {
        this.fromPassword = fromPassword;
    }
}
