package com.xunlei.niux.client.gameinfo;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.util.Log;
import org.slf4j.Logger;

/**
 * Created by jamesjxin on 15-1-29.
 */
public class UserGamePay {
    private static final Logger logger = Log.getLogger(UserGamePay.class);
    private static final String BaseUrl = "http://dq2.niu.xunlei.com/isPayer?";

    public static boolean isUserPayedGame(long userId){
        try {
            String url = BaseUrl;
            url += "userId="+String.valueOf(userId);

            logger.info("request Url:{}",url);
            String response = HttpClientUtil.get(url);
            logger.info("response:{}",response);

            JsonObject jsonObject = new JsonParser().parse(response).getAsJsonObject();
            if(jsonObject == null){
                return false;
            }

            JsonObject dataObject = jsonObject.get("data").getAsJsonObject();
            if (dataObject == null){
                return false;
            }

            boolean result = dataObject.get("isPayer").getAsBoolean();

            return result;
        } catch (JsonSyntaxException e) {
            logger.error("userId:{} isUserPayedGame check Exception",userId,e);
            return false;
        }
    }
}
