package com.xunlei.niux.client.gameinfo;

import java.util.HashMap;
import java.util.Map;

import com.xunlei.niux.client.util.URLUtil;
import com.xunlei.niux.common.exception.NiuRuntimeException;

/**
 * 查询用户游戏等级
 * @author Administrator
 *
 */
public class UserGameLevelQuery {
	private  static String GameInfoUrl="http://websvr.niu.xunlei.com";
	/**
	 * 查询用户用户等级
	 * @param sessionId 登录态
	 * @param userName 账户名
	 * @param gameId 游戏gameid
	 * @param serverId 游戏服务器id
	 * @return 游戏等级
	 */
	public static int queryUserGameLevel(String sessionId,String userName,String gameId,String serverId){
		StringBuilder sb=new StringBuilder(GameInfoUrl);
		sb.append("/queryGameUserLevel.gameUserInfo?")
		  .append("sessionid=").append(sessionId)
		  .append("&username=").append(userName)
		  .append("&gameid=").append(gameId)
		  .append("&serverid=").append(serverId);
		String respStr=URLUtil.get(sb.toString());
		//解析字符串
		respStr=respStr.replaceAll("[\\{\\}\"]", "");
		//分割字符串
		String[] array1=respStr.split(",");
		Map<String,String> map=new HashMap<String,String>();
		for(String str:array1){
			if(str==null||"".equals(str)){
				continue;
			}
			String[] array2=str.split(":");
			if(array2==null||array2.length!=2){
				break;
			}
			map.put(array2[0], array2[1]);
		}
		//判断是否具有等级
		String status=map.get("statues");
		if("0".equals(status)){
			return Integer.valueOf(map.get("level"));
		}
		throw new NiuRuntimeException("1030", "没有创建角色");
	}
	public static void main(String[] args){
		String respStr="{\"level\":\"2\",\"onlineTime\":0,\"statues\":\"0\"}";
		respStr=respStr.replaceAll("[\\{\\}\"]", "");
		System.out.println(respStr);
	}
}
