package com.xunlei.niux.client.gameinfo;

import com.google.gson.*;
import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.util.Log;
import org.slf4j.Logger;

/**
 * Created by jamesjxin on 15-1-29.
 */
public class UserGameInfo {
    private static final Logger logger = Log.getLogger(UserGameInfo.class);
    private static final String BaseUrl = "http://websvr.niu.xunlei.com/userGameServerList.gameUserInfo?";

    /**
     * 判断用户是否玩过游戏
     * @param sessionId
     * @param userName
     * @return
     */
    public static boolean isUserPlayedGame(String sessionId, String userName) {
        try {
            String url = BaseUrl;
            url += "sessionid="+sessionId;
            url += "&username="+userName;
            url += "&records=1";

            logger.info("request Url:{}",url);
            String response = HttpClientUtil.get(url);
            logger.info("response:{}",response);

            JsonObject jsonObject = new JsonParser().parse(response).getAsJsonObject();
            if(jsonObject == null){
                return false;
            }
            JsonObject dataObject = jsonObject.get("data").getAsJsonObject();
            if(dataObject == null){
                return false;
            }
            JsonArray dataArray = dataObject.getAsJsonArray("data");
            if( dataArray == null || dataArray.size() < 1 ){
                return false;
            }

            return true;
        } catch (Exception e) {
            logger.error("userName:{} check isUserPlayedGame Exception",userName,e);
            return false;
        }
    }
}
