package com.xunlei.niux.client.card;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xunlei.niux.client.util.*;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;

import java.io.IOException;
import java.util.Map;

/**
 * 领取新手卡和礼包激活码
 *
 * @author hezhong
 */
public class CardClient {
    private static Logger logger = Log.getLogger(CardClient.class);

    private static String card_url = EnvPropertyUtil.loadProperty("niux", "card_url");

    private static String newCard_url = EnvPropertyUtil.loadProperty("niuxclient", "newcard_url");

    private static final String KEY = "febd6f8dft3e412d4beb69c68ed41e";

    public static final String GIFT = "gift";

    public static final String CARD = "card";


    /**
     * @param gameid   游戏ID
     * @param serverid 服务器ID
     * @param type     领取类型：card:新手卡；gift:礼包
     * @param batid    批次id
     * @param userid   迅雷id
     * @param username 迅雷账号
     * @param getmore  getmore=true 时可以多领，为false只能领取一个,不传，默认为false,不可多领
     * @return
     * @throws java.io.IOException
     */
    public static String sender(String gameid, String serverid, String type, String batid, long userid, String username,boolean getmore) {
        if (StringUtil.isEmpty(gameid, serverid, type, batid, username)) {
            throw new NullPointerException("参数不能为空");
        }

        if (!GIFT.equals(type) && !CARD.equals(type)) {
            throw new IllegalArgumentException("type value must be gift or card");
        }

        String sign = SignUtil.sign(gameid + serverid + username + userid, KEY);
        String url = String.format(card_url, gameid, serverid, type, batid, userid, username, sign, getmore);

        logger.debug("新手卡接口url:{}", url);

        return HttpClientUtil.get(url);
    }

    /**
     * 获取激活码
     */
    @SuppressWarnings("unchecked")
    public static String getCardCode(String gameid, String serverid, String type, String batid, long userid, String username, boolean getmore) {
        String code = null;

        try {
            String reslut = sender(gameid, serverid, type, batid, userid, username, getmore);
            ObjectMapper mapper = new ObjectMapper();
            Map<String, Object> map = mapper.readValue(reslut, Map.class);

            if(0 == (Integer) map.get("code")) {
                code = map.get("result").toString();
            } else {
                logger.warn("获取激活码错误:{}", reslut);
            }

        } catch (Exception e) {
            logger.error("获取激活码异常", e);
        }

        return code;
    }
    /**
     * 获取激活码。如果领取失败，抛出异常
     * @param gameid
     * @param serverid
     * @param type
     * @param batid
     * @param userid
     * @param username
     * @param getmore
     * @return
     */
    @SuppressWarnings("unchecked")
    public static String getCardCode22(String gameid, String serverid, String type, String batid, long userid, String username, boolean getmore) {
        try {
            String reslut = sender(gameid, serverid, type, batid, userid, username, getmore);
            ObjectMapper mapper = new ObjectMapper();
            Map<String, Object> map = mapper.readValue(reslut, Map.class);
            Integer code=(Integer) map.get("code");
            if(code==0||code==2) {
               String cardNo = map.get("result").toString();
               return cardNo;
            } 
            String message=(String)map.get("message");
            if(code==-2){
            	throw new NiuRuntimeException("1030", message);//没有创建游戏角色
            }
            if(message.contains("暂无新手卡")){
            	throw new NiuRuntimeException("1017","没有礼包或已兑换完");
            }
            throw new NiuRuntimeException("99", message);//没有创建游戏角色
        } catch(NiuRuntimeException e){
        	logger.error("获取激活码异常", e);
        	throw e;
        }
        catch (Exception e) {
            logger.error("获取激活码异常", e);
            throw new NiuRuntimeException("99", e);//没有创建游戏角色
        }

    }

    public static Map<String,Object> getNewCardBatIdByGameId(String gameId){
        String url = newCard_url + "action=getGameBatchId&gameId="+gameId;

        logger.info("getNewCardBatIdByGameId request url:"+url);
        String resp = HttpClientUtil.get(url);
        logger.info("getNewCardBatIdByGameId response result:"+resp);

        JsonObject jsonObject = new JsonParser().parse(resp).getAsJsonObject();
        int code = jsonObject.get("code").getAsInt();
        if(code != 0){
            return MapEasyUtils.generateMap(code,jsonObject.get("message").getAsString());
        }

        return MapEasyUtils.generateMap(code,jsonObject.get("result").getAsString());
    }

    public static CardClientResult getResult(String gameid, String serverid, String type, String batid, long userid, String username, boolean getmore) {
        CardClientResult result = new CardClientResult();

        try {
            String strReslut = sender(gameid, serverid, type, batid, userid, username, getmore);
            ObjectMapper mapper = new ObjectMapper();
            Map<String, Object> map = mapper.readValue(strReslut, Map.class);

            final Integer code = (Integer) map.get("code");
            result.setCode(code);
            result.setMessage( map.get("message").toString());

            if(CardClientResult.SUCCESS_CODE == code || CardClientResult.HAS_SUCCESS_CODE == code) {
                result.setResult( map.get("result").toString());
            }

        } catch (Exception e) {
            logger.error("获取激活码异常", e);
            result = null;
        }

        return result;
    }

    public static void main(String[] args) throws IOException {
        System.out.println(getCardCode("00087", "1", GIFT,"49", 246880500, "246880500", false));
    }

    /**
     * @author hezhong
     */
    public static class CardClientResult {

        public static final int SUCCESS_CODE = 0;

        public static final int HAS_SUCCESS_CODE = 2;

        public static final int NONE_CODE = -99;

        public static final int NO_PLAY = -2;

        private int code;
        private String message;
        private String result;

        public int getCode() {
            return code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMessage() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getResult() {
            return result;
        }

        public void setResult(String result) {
            this.result = result;
        }
    }
}
