package com.xunlei.niux.client.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * Created by jamesjxin on 14-8-29.
 */
public class PropertiesReader {
    private String defaultDir = "/";
    private Properties props;

    public PropertiesReader(String fileName) throws IOException {
        props = new Properties();
        String profile = System.getProperty("profile." + fileName);

        InputStream in = profile != null ? new FileInputStream(profile)
                : PropertiesReader.class.getResourceAsStream(defaultDir
                + fileName);

        props.load(in);
        in.close();
    }

    public String getProperty(String property) {
        return (String) props.get(property);
    }
}
