package com.xunlei.niux.client.jinzuan;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.client.jinzuan.dto.MemberShipDTO;
import com.xunlei.niux.client.jinzuan.dto.PrivilegeReceiveInfoDTO;
import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.niux.client.util.MapEasyUtils;
import com.xunlei.util.Log;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 14-3-7
 * Time: 上午11:20
 * To change this template use File | Settings | File Templates.
 */
public class MemberInfoClient {
    private static Logger logger = Log.getLogger(MemberInfoClient.class);
    private final static String MemberUrl = "http://jinzuan.niu.xunlei.com:9090/member/";


    public static MemberShipDTO getMemberInfo(String userId) throws RuntimeException {
        if (StringUtils.isEmpty(userId)) {
            throw new RuntimeException("参数userId不能为空！");
        }
        String url = MemberUrl + "getmember.do?uid=" + userId;
        logger.info("请求URL为：" + url);
        String resp = HttpClientUtil.get(url);
        logger.info("请求结果为：" + resp);
//        String resp = "{\"rtn\":0,\"data\":{\"memberinfo\":{\"growthValue\":1873,\"levelGrowthValue\":1800,\"lastFeeTime\":\"2014-03-13 14:12:01\",\"userId\":123540516,\"memberExpireDate\":\"2014-06-13\",\"memberType\":2,\"isYear\":0,\"nextLevelGrowthValue\":1800,\"annualMemberExpireDate\":\"2014-03-13\",\"levelNum\":3,\"registerTime\":\"2014-01-12 00:00:05\"},\"prilist\":[{\"yearMonth\":\"2014-03\",\"userId\":123540516,\"availableValue\":0,\"seqId\":1,\"recordTime\":\"2014-03-07 00:00:00\",\"privilegeType\":3,\"totalValue\":10,\"simpleName\":\"dhyb\"},{\"yearMonth\":\"2014-03\",\"userId\":123540516,\"availableValue\":2,\"seqId\":2,\"recordTime\":\"2014-03-13 00:00:00\",\"privilegeType\":1,\"totalValue\":200,\"simpleName\":\"mfsc\"},{\"yearMonth\":\"2014-03\",\"userId\":123540516,\"availableValue\":0,\"seqId\":3,\"recordTime\":\"2014-03-13 00:00:00\",\"privilegeType\":4,\"totalValue\":200,\"simpleName\":\"lxgj\"}]}}";
        JsonObject result = new JsonParser().parse(resp).getAsJsonObject();
        int rtnCode = result.get("rtn").getAsInt();
        if (rtnCode == 0) {
            Gson gson = new Gson();
            JsonObject dataObject = result.getAsJsonObject("data");
            MemberShipDTO memberShip = null;
            if (dataObject.get("memberStatus") != null) {
                memberShip = new MemberShipDTO();
                memberShip.setMemberStatus(dataObject.get("memberStatus").getAsInt());
            } else {
                memberShip = gson.fromJson(dataObject.get("memberinfo"), MemberShipDTO.class);
                List<PrivilegeReceiveInfoDTO> priInfoList = gson.fromJson(dataObject.get("prilist"), new TypeToken<List<PrivilegeReceiveInfoDTO>>() {
                }.getType());
                memberShip.setPrilist(priInfoList);
            }


            return memberShip;
        } else if (rtnCode == 1) {
            throw new RuntimeException("参数为空！");
        } else if (rtnCode == 2) {
            throw new RuntimeException("该用户非金钻用户！");
        } else if (rtnCode == 3) {
            throw new RuntimeException("网络异常！");
        } else if (rtnCode == 4) {
            throw new RuntimeException("无效Ip！");
        } else {
            throw new RuntimeException("未知返回码：" + rtnCode);
        }
    }

    //获取金钻等级
    public static int getJinZuanLevel(String userId) {
        int level = 0;

        String cacheKey = MemberInfoClient.class+ "userId_"+userId;
        CacheManager cacheManager = CacheManager.GetInstance();
        //从缓存获取数据
        Object object = cacheManager.get(cacheKey);
        if(object == null ){
            //获取数据逻辑
            Map<String,Object> resultMap = MemberInfoClient.getBasicMemberInfo(userId);
            int code = Integer.parseInt(resultMap.get("code").toString());
            if(code != 0){
                return level;
            }

            MemberShipDTO memberShipDTO = (MemberShipDTO)resultMap.get("data");
            if (memberShipDTO == null) {
                return 0;
            }
            level = (memberShipDTO.getLevelNum() == null || memberShipDTO.getLevelNum() < 0) ? 0 : memberShipDTO.getLevelNum();
            //更新缓存
            if(level > 0 ){
                cacheManager.put(cacheKey,level,5);
            }
        } else {
            level = (Integer)object;
        }

        return level;
    }

    public static void main(String[] args) {
        Map<String,Object> memberShip = MemberInfoClient.getBasicMemberInfo("aaa");
        System.out.println("success!");
    }

    public static Map<String,Object> getBasicMemberInfo(String userId) {

        if (StringUtils.isEmpty(userId)) {
            throw new RuntimeException("参数userId不能为空！");
        }
        String url = MemberUrl + "getmemberinfo.do?uid=" + userId;
        logger.info("请求URL为：" + url);
        String resp = HttpClientUtil.get(url);
        logger.info("请求结果为：" + resp);

//        String resp = "{\"data\":{\"growthValue\":101,\"isAnnualMember\":0,\"levelGrowthValue\":0,\"lastFeeTime\":\"2014-04-10 13:31:59\",\"userId\":256037852,\"memberExpireDate\":\"2014-05-11\",\"nextLevelGrowthValue\":600,\"memberStatus\":1,\"annualMemberExpireDate\":\"\",\"levelNum\":1,\"registerTime\":\"2014-04-10 13:31:59\"},\"rtn\":0}";

        JsonObject result = new JsonParser().parse(resp).getAsJsonObject();
        int rtnCode = result.get("rtn").getAsInt();
        if (rtnCode != 0) {
            String msg =  result.get("data").getAsString();
            return MapEasyUtils.generateMap(rtnCode,msg);
        }
//        else if (rtnCode == 1) {
//            return MapEasyUtils.generateMap(1,"参数为空!");
//            throw new RuntimeException("参数为空！");
//        } else if (rtnCode == 2) {
//            throw new RuntimeException("无效Ip！");
//        } else if (rtnCode == 3) {
//            throw new RuntimeException("该用户非金钻会员！");
//        } else if (rtnCode == 4) {
//            throw new RuntimeException("网络异常！");
//        } else {
//            throw new RuntimeException("未知返回码：" + rtnCode);
//        }

        Gson gson = new Gson();
        MemberShipDTO memberShip = gson.fromJson(result.get("data"), MemberShipDTO.class);

        return MapEasyUtils.generateMap(0,memberShip);

    }

}
