package com.xunlei.niux.client.gameinfo;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.xunlei.json.JSONEncoder;
import com.xunlei.json.JSONUtil;
import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.niux.client.util.SignUtil;
import com.xunlei.util.Log;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by jamesjxin on 14-6-12.
 */
public class UserGameLoginDays {
    private static final Logger logger = Log.getLogger(UserGameLoginDays.class);
    private static final String Url = "http://dq2.niu.xunlei.com/act/getLoginDays?";

    public static int UserLonggestLoginDays(String userId,String fromDate,String toDate,String gameId,String serverId){
        Map<String,String> params = new HashMap<String, String>();
        params.put("userId",userId);
        params.put("from",fromDate);
        params.put("to",toDate);
        params.put("gameId",gameId==null?"":gameId);
        params.put("serverId",serverId==null?"":serverId);

        String queryUrl = Url+ SignUtil.getSignatureContent(params);

        logger.info("UserLonggestLoginDays query Url:"+queryUrl);
        String result = HttpClientUtil.get(queryUrl);
//        String result = "{\"rtn\":0,\"data\":{\"days\":[\"20140321\",\"20140322\",\"20140323\",\"20140324\",\"20140325\",\"20140326\",\"20140327\",\"20140328\",\"20140329\",\"20140330\",\"20140331\",\"20140401\",\"20140402\",\"20140403\"]}}";
        logger.info("UserLonggestLoginDays query Result:"+result);

        JsonObject jsonObject = new JsonParser().parse(result).getAsJsonObject();
        int code = jsonObject.get("rtn").getAsInt();
        if(code != 0){
            logger.error("URL:{} 请求失败！",queryUrl);
            return 0;
        }

        Gson gson = new Gson();
        Map<String,Object> map = gson.fromJson(jsonObject.get("data"),new TypeToken<Map<String,Object>>(){}.getType());
        List<String> dateStringList = (List<String>)map.get("days");

        if(dateStringList.size() <= 0){
            return 0;
        }

        return getLonggestDays(dateStringList);
    }

    private static int getLonggestDays(List<String> dateStringList){
        String preDate = "",curDate = "";

        int longgestDay = 0;
        int curContinuDay = 1;
        for(String dateStr : dateStringList){
            curDate = dateStr;
            if(StringUtils.isNotEmpty(preDate)){
                if(isCurDateAfterPreDate(preDate,curDate)){
                    curContinuDay++;
                }else{
                    if(curContinuDay > longgestDay){
                        longgestDay = curContinuDay;
                        curContinuDay = 1;
                    }
                }

            }
            preDate = curDate;
        }

        if(curContinuDay > longgestDay){
            longgestDay = curContinuDay;
        }

        return longgestDay;
    }

    private static boolean isCurDateAfterPreDate(String preDate,String curDate){
        DateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        try {
            calendar1.setTime(sdf.parse(preDate));
            calendar2.setTime(sdf.parse(curDate));

            int n = calendar2.get(Calendar.DAY_OF_YEAR) - calendar1.get(Calendar.DAY_OF_YEAR);

            if(n == 1){
                return true;
            }

            return false;
        } catch (ParseException e) {
            return false;
        }
    }

}
