package com.xunlei.niux.client.daijinquan;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;

import com.xunlei.niux.client.util.SignUtil;
import com.xunlei.niux.client.util.StringUtil;
import com.xunlei.niux.client.util.URLUtil;
import com.xunlei.niux.common.exception.NiuRuntimeException;

/**
 * 新发放代金券
 * @author Administrator
 *
 */
public class NewDaiJinQuanClient {
	private  static Logger logger=Logger.getLogger(NewDaiJinQuanClient.class.getName());
	private static String daijinquanurl="http://dy.niu.xunlei.com:80/card/updatecardcountnew.do?";
	private static String bizNo="00004";
	private static String bizPwd="mpobwhb9fkar6t7";
	/**
	 * 发放代金券。如果发放失败，抛出异常
	 * @param uid 迅雷UID
	 * @param orderId 订单号
	 * @param num 面值（分为单位）
	 * @param bizNo 业务号
	 * @param bizPwd 业务密码
	 */
	public static void giveOut(String actNo,String uid,String orderId,String type,long num){
		//判断参数是否为空
		if(StringUtil.isEmpty(actNo,uid,orderId,bizNo,bizPwd,type)){
			logger.error("uid["+uid+"]orderId["+orderId+"]bizNo["+bizNo+"]type["+type+"]");
			throw new RuntimeException("参数为空");
		}
		//判断面值是否有效
		if(!"|100|200|300|500|1000|990|1490|".contains("|"+num+"|")){
			logger.error("daijinquan num["+num+"]");
			throw new RuntimeException("不存在该代金券面值");
		}
		//转换面值的单位，由分转化为元，进率为100.注意:没有小数时，只能显示整数；有小数时，显示一位小数
		String dnum=(num%100==0)?num/100+"":num*1.0/100+"";
		//签名
		String sign=sign(uid,actNo,type,orderId,dnum,bizNo,bizPwd);
		//拼接url
		String djqurl=concatUrl(uid,actNo,type, orderId, dnum, bizNo, sign);
		//发放
		//logger.info("daijinquan give out url:"+djqurl);
		String resp=URLUtil.get(djqurl);
		//logger.info("daijinquan give out resp:"+resp);
		//判断响应是否ok，如果发放不成功，抛出异常
		parseResp(resp);
	}
	private static void parseResp(String resp){
		if(resp==null){
			throw new NiuRuntimeException("99", "发放代金券格式错误");
		}
		if(resp.contains("\"rtn\":0")||resp.contains("\"rtn\":3")){
			return;//表示成功
		}
		if(resp.contains("\"rtn\":14")){
			throw new NiuRuntimeException("1017", "已领取完");
		}
		throw new NiuRuntimeException("99", resp);
	}
	/**
	 * 签名字段
	 * @param uid
	 * @param orderId
	 * @param dnum
	 * @param bizNo
	 * @param bizPwd
	 * @return
	 */
	private static String sign(String uid,String actNo,String type,String orderId,String dnum,String bizNo,String bizPwd){
		Map<String,String> map=new HashMap<String,String>();
		map.put("uid", uid);
		map.put("actno", actNo);
		map.put("type", type);
		map.put("authid", bizNo);
		map.put("num1", dnum);
		map.put("orderid", orderId);
		return SignUtil.sign(map, bizPwd);
	}
	private static String concatUrl(String uid,String actNo,String type,String orderId,String dnum,String bizNo,String sign){
		Map<String,String> map=new HashMap<String,String>();
		map.put("uid", uid);
		map.put("actno", actNo);
		map.put("type", type);
		map.put("authid", bizNo);
		map.put("num1", dnum);
		map.put("orderid", orderId);
		map.put("sign", sign);
		String param=SignUtil.getSignatureContent(map);
		if(!daijinquanurl.contains("?")){
			return daijinquanurl+"?"+param;
		}
		if(daijinquanurl.endsWith("&")){
			return daijinquanurl+param;
		}
		return daijinquanurl+"&"+param;
	}
	public static void main(String[] args){
		NewDaiJinQuanClient client=new NewDaiJinQuanClient();
		client.giveOut("chouvip", "299288598", "chouviptest0001", "cash", 1490);
	}
}
