package com.xunlei.niux.client.jinzuan;

import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.util.Log;
import org.slf4j.Logger;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.ResourceBundle;

/**
 * Created by jamesjxin on 14-4-8.
 */
public class JinZuanPayClient {
    private static final Logger logger = Log.getLogger(JinZuanPayClient.class);
    private static final String URL = "http://payjz.niu.xunlei.com:8091/jinzuan/";
    private static final String bizNo = ResourceBundle.getBundle("niuxclient").getString("JinZuanPayClient_bizNo");
    private static final String priKey = ResourceBundle.getBundle("niuxclient").getString("JinZuanPayClient_priKey");
    private static SimpleDateFormat sdf_time=new SimpleDateFormat("yyyyMMddHHmmss");


    /**
     * @param timeType 时间类型 1：日 2：月 3：年，目前只支持日
     * @param numValue 赠送天数
     * @return
     */
    public static String FreeCharge(String actNo, long userId, int timeType, int numValue) {
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000);
        Random random = new Random(System.currentTimeMillis());
        String orderId = sdf_time.format(new Date())+random.nextInt(100000) + "_ACT";

        String url = URL + "present.do?";
        url += "uid=" + String.valueOf(userId);
        url += "&orderid=" + orderId;
        url += "&timeType=" + timeType;
        url += "&numValue=" + numValue;
        url += "&bizNo=" + bizNo;
        url += "&timestamp=" + timestamp;
        url += "&actno="+ actNo;

        String sign = Md5Encrypt.md5(userId + orderId + timeType + numValue + bizNo + timestamp + priKey);
        url += "&sign="+sign;

        logger.info("FreeCharge request URL: "+url);
        String resp = HttpClientUtil.get(url);
        logger.info("FreeCharge request response: "+resp);

        return resp;
    }
}
