package com.xunlei.niux.client.yuanbao;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

import com.xunlei.common.util.StringTools;
import com.xunlei.niux.client.util.SignUtil;
import com.xunlei.niux.client.util.URLUtil;
import com.xunlei.niux.client.util.URLUtil.URLProperty;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.util.Log;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class YuanBaoClient {
    private static Logger logger = Log.getLogger(YuanBaoClient.class);
	private static String yuanbaourl="http://paysvr.niu.xunlei.com:8090";
	private static String privateKey="89oi8=9kmikmnjjdls;dkkks-xkkoldl";
	private static String privateKey_check="ko-099mnygukkulh";

	public static void giveOutYuanBao(String userName,String gameId,String serverId,String orderNo,String actNo,Integer unitprice){
        giveOutYuanBao("",userName,gameId,serverId,"",orderNo,actNo,unitprice);
	}

	public static void giveOutYuanBao(String userName,String gameId,String serverId,String orderNo,String actNo,Integer unitprice,String roleId){
        giveOutYuanBao("",userName,gameId,serverId,roleId,orderNo,actNo,unitprice);
	}

    public static void giveOutYuanBao(String userName,String gameId,String serverId,String roleId,String orderNo,String actNo,Integer unitprice){
        giveOutYuanBao("",userName,gameId,serverId,roleId,orderNo,actNo,unitprice);
    }

	public static void giveOutYuanBao(String userId,String userName,String gameId,String serverId,String roleId,String orderNo,String actNo,Integer unitprice){
		//签名
		Map<String,String> paramMap=new HashMap<String,String>();
		paramMap.put("gameid", gameId);
		paramMap.put("getusername", userName);
		paramMap.put("goodstimes", "1");
		paramMap.put("niuxactno", actNo);
		paramMap.put("originalorderid", orderNo);
		paramMap.put("unitprice",unitprice+"");
		paramMap.put("roleid", roleId==null?"":roleId);
		paramMap.put("serverid",serverId);
		String content=SignUtil.getSignatureContent(paramMap);
		String signMsg=SignUtil.sign(content, privateKey);
		StringBuilder sb=new StringBuilder();
		sb.append(yuanbaourl).append("/gamepaycenter/genorder?action=genorder")
		  .append("&gameid=").append(gameId)
		  .append("&getusername=").append(twoEncode(userName))
		  .append("&serverid=").append(serverId)
		  .append("&servername=").append(twoEncode(""))
		  .append("&roleid=").append(twoEncode(roleId==null?"":roleId))
		  .append("&rolename=").append(twoEncode(""))
		  .append("&paybiz=0&chargetype=").append("S")
		  .append("&unitprice=").append(unitprice).append("&goodstimes=1").append("&bankno=")
		  .append("&niuxactno=").append(actNo)
		  .append("&originalorderid=").append(orderNo)
		  .append("&signMsg=").append(signMsg);
        if(StringUtils.isNotEmpty(userId)){
            sb.append("&getUserId="+userId);
        }
        
        logger.info("giveOutYuanBao url:"+sb.toString());
        
        URLProperty pro = new URLProperty();
        pro.setReadTimeout(300000);//设置超时为5分钟（uid查username、查角色、调游戏充值接口），保证调充值服务已调用到并返回。
        String respUrl = "var defaultRtnName = {code:0}";
        
        try{
        	respUrl = URLUtil.get(sb.toString(),pro);
        }catch(Exception e){//如果仍然抛出超时异常的话，查一下是否有充值订单，没有就抛出异常（外层业务可能需要回滚了）。
        	boolean hasPayed = isFirstPayGameServer(userName,gameId,serverId,null,null, orderNo, userId);
            logger.error("giveOutYuanBao respUrl:"+respUrl+",hasPayed:"+hasPayed, e);
        	if(!hasPayed){
        		throw new NiuRuntimeException("99", "充值失败");
        	}
        }
        
        logger.info("giveOutYuanBao resp:"+respUrl);
        
		if(!(respUrl.contains("code:0")||respUrl.contains("code:1"))){
			String msg=respUrl.substring(respUrl.indexOf("'"),respUrl.lastIndexOf("'"));
			try {
				msg=URLDecoder.decode(msg, "UTF-8");
				if(msg.contains("充值账号非游戏用户")){
					throw new NiuRuntimeException("1030", msg);
				}
			} catch (UnsupportedEncodingException e) {
				throw new NiuRuntimeException("99","字符集转换失败");
			}
			throw new NiuRuntimeException("99",msg);
		}
	}

	/**
     * 获取玩家是否有充值记录
     * @param username
     * @param gameId
     * @param serverId
     * @return true有 false无和异常
     * @throws NiuRuntimeException
     */
    public static boolean isFirstPayGameServer(String username,String gameId,String serverId)throws NiuRuntimeException{
        return isFirstPayGameServer(username,gameId,serverId,null,null);
    }

    /**
     * 获取玩家是否有充值记录
     * @param username
     * @param gameId
     * @param serverId
     * @param beginTime
     * @param endTime
     * @return true有 false无和异常
     * @throws NiuRuntimeException
     */
    public static boolean isFirstPayGameServer(String username,String gameId,String serverId,String beginTime,
                                               String endTime)throws NiuRuntimeException{
    	return isFirstPayGameServer(username,gameId,serverId,beginTime,endTime, null, null);
    }
    
    /**
     * 获取玩家是否有充值记录
     * @param username
     * @param gameId
     * @param serverId
     * @param beginTime
     * @param endTime
     * @param originalOrderId
     * @param getUserId
     * @return true有 false无和异常
     * @throws NiuRuntimeException
     */
    public static boolean isFirstPayGameServer(String username,String gameId,String serverId,String beginTime,
                String endTime, String originalOrderId, String getUserId)throws NiuRuntimeException{
    	
    	if(StringTools.isEmpty(username) || StringTools.isEmpty(gameId) || StringTools.isEmpty(serverId)){
    		logger.warn("isFirstPayGameServer param empty.username:"+username+",gameId:"+gameId+",serverId:"+serverId);
    		return false;
    	}
    	
		if (StringTools.isEmpty(getUserId)) {
			getUserId = "";
		}
		
        String content = getUserId + gameId + serverId;
        String signMsg=SignUtil.sign(content, privateKey_check);
        StringBuilder sb=new StringBuilder();
        sb.append(yuanbaourl).append("/gamepaycenter/recharge?action=checkcharge")
                .append("&gameid=").append(gameId)
                .append("&username=").append(twoEncode(username))
                .append("&serverid=").append(serverId)
                .append("&begintime=").append(twoEncode(beginTime))
                .append("&endtime=").append(twoEncode(endTime))
                .append("&originalOrderId=").append(twoEncode(originalOrderId))
                .append("&userid=").append(getUserId)
                .append("&sign=").append(signMsg);
        logger.info("isFirstPayGameServer url:"+sb.toString());
        String respUrl=URLUtil.get(sb.toString());
        logger.info("isFirstPayGameServer resp:"+respUrl);
        if(respUrl.contains("\"code\":\"0\"")){
           return true;
        }else if(respUrl.contains("\"code\":\"-1\"")){
           return false;
        }else if(respUrl.contains("\"code\":\"-2\"")){
            throw new NiuRuntimeException("-2", "签名验证失败");
        }else if(respUrl.contains("\"code\":\"-3\"")){
            throw new NiuRuntimeException("-3", "参数错误");
        }else{
            String msg=respUrl.substring(respUrl.indexOf("'"),respUrl.lastIndexOf("'"));
            try {
                msg=URLDecoder.decode(msg, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                throw new NiuRuntimeException("99","字符集转换失败");
            }
            throw new NiuRuntimeException("99",msg);
        }
    }

	private static String twoEncode(String value){
		if(value==null||"".equals(value)){
			return "";
		}
		try {
			value=URLEncoder.encode(value, "UTF-8");
			return value;
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException();
		}
	}

	public static void main(String[] args){
		System.out.println(twoEncode("8414"));
		 try {
			 
			//签名
				Map<String,String> paramMap=new HashMap<String,String>();
				paramMap.put("gameid", "000136");
				paramMap.put("getusername", "gu303fff");
				paramMap.put("goodstimes", "1");
				paramMap.put("niuxactno", "BonusExchangeCoin");
				paramMap.put("originalorderid", "BEx14447170938579530");
				paramMap.put("unitprice",1+"");
				paramMap.put("roleid", "");
				paramMap.put("serverid","1");
				String content=SignUtil.getSignatureContent(paramMap);
				String signMsg=SignUtil.sign(content, privateKey);
				
//			 YuanBaoClient.giveOutYuanBao("123540516","youxiceshi", "000075", "23","0", "183505834505_yyl", "test", 1);
			 boolean hasPayed = YuanBaoClient.isFirstPayGameServer("youxiceshi","000075","23",null,null, "","");
			System.out.println(URLDecoder.decode(URLDecoder.decode("8414", "utf-8"), "utf-8"));
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
